module Aufgabe7 where

-----------------------------------------------

inOut :: (String -> String) -> IO Integer
inOut func = do line <- getLine
                if line == "end" then return 0
                   else do putStrLn (func line)
                           x <- inOut func
                           return (1 + x)


-----------------------------------------------


data Token = Wrong | Mult | Add | Value Integer deriving (Eq, Show)

tokenize :: String -> [Token]
tokenize []     = []
tokenize xss@(x:xs) | isSpace x           = tokenize xs
                    | x == '*'            = Mult : tokenize xs
                    | x == '+'            = Add : tokenize xs
                    | x == '-'            = Value (negate (read (extractValue xs)::Integer)) : tokenize (drop (length (extractValue xs)) xs)
                    | isDigit x           = Value (read (extractValue xss)::Integer) : tokenize (drop (length (extractValue xss) - 1) xs)
                    | otherwise           = Wrong : tokenize xs


-----------------------------------------------


extractValue :: String -> String
extractValue [] = []
extractValue (x:xs) | isDigit x = x : extractValue xs
                    | otherwise = []


-----------------------------------------------


toString :: [Integer] -> String
toString [] = "Error"
toString xs = init (concat [show a ++ " "  | a <- (reverse xs)])


-----------------------------------------------


interpret :: [Token] -> [Integer]
interpret (Value v1:Value v2:Value v3:ts) = (interpret (Value v2:Value v3:ts)) ++ [v1]
interpret (Value v1:Value v2:Add:ts) = interpret (Value(v1+v2):ts)
interpret (Value v1:Value v2:Mult:ts) = interpret (Value(v1*v2):ts)
interpret (Value v1:Value v2:[]) = [v2,v1]
interpret (Value v1:[]) = [v1]
interpret [] = []
interpret x = []


-----------------------------------------------
-----------------------------------------------


main :: IO ()
main = do count <- inOut (\x -> toString (interpret (tokenize x)))
          putStr (show count ++ " Zeilen")



