
rev :: [a] -> [a]
rev [] = []
rev (x:[]) = [x]
rev (x:xs) = rev(xs) ++ [x]



append :: [a] -> a -> [a] -> [a]
append [] y zs = y : zs
append (x:xs) y zs = x : append xs y zs



fld :: (a -> a -> a) -> [a] -> a
fld y (x:[]) = x
fld y (x:xs) = y x (fld y xs)



data Tree a = Leaf a | Branch (Tree a) (Tree a) deriving Show


toList :: Tree a -> [a]
toList (Leaf x) = [x]
toList (Branch x y) = (toList x) ++ (toList y)

toTree :: [a] -> Tree a
toTree (x:[]) = (Leaf x)
toTree (x:xs) = Branch (toTree xs) (Leaf x)

