module Aufgabe9 where

import Monad

-----

data StMaybe s v = Failure s | Success s v
data MaybeState s v = MS (s -> StMaybe s v)

toMaybeState :: v -> Int -> MaybeState Int v
toMaybeState v n = MS (\s -> (Success n v))

toWrongMaybeState :: Int -> MaybeState Int ()
toWrongMaybeState n = MS (\s -> (Failure n))

fromMaybeState :: MaybeState Int v -> (Int, v)
fromMaybeState (MS f) = (s, v) where Success s v = f 0

stateFromMaybeState :: MaybeState Int v -> Int
stateFromMaybeState (MS f) = case (f 0) of {
                                         Failure s -> s;
                                         Success s v -> s
                                        }

-----


instance Monad (MaybeState s) where
    return v = MS (\s -> Success s v)
    MS f >>= g = MS (\s -> case (f s) of {
                                          Success s' v -> let MS fun = g v in fun s';
                                          Failure s' -> Failure s'
                                         }
                    )


-----


data State = State Int Int Int Int Int deriving Show

addOp :: State -> State
addOp (State a m as ms l) = if l == 1 then State (a+1) m (as+1) ms 1 else State (a+1) m as ms 1

mulOp :: State -> State
mulOp (State a m as ms l) = if l == 2 then State a (m+1) as (ms+1) 2 else State a (m+1) as ms 2

plus, minus, mal, rest, durch :: Integer -> Integer -> MaybeState State Integer

plus a b  = if (a+b) >= 0 then
            MS (\s -> Success (addOp s) (a+b))
            else
            MS (\s -> Failure s)

minus a b = if (a-b) >= 0 then
            MS (\s -> Success (addOp s) (a-b))
            else
            MS (\s -> Failure s)

mal a b   = if (a*b) >= 0 then
            MS (\s -> Success (mulOp s) (a*b))
            else
            MS (\s -> Failure s)

durch a b = if (div a b) >= 0 then
            MS (\s -> Success (mulOp s) (div a b))
            else
            MS (\s -> Failure s)

rest a b  = if (mod a b) >= 0 then
            MS (\s -> Success (mulOp s) (mod a b))
            else
            MS (\s -> Failure s)


-----


test :: MaybeState State Integer -> (Integer, Int, Int, Int, Int)
test (MS f) = case (f (State 0 0 0 0 (-1))) of {
                                                Success (State a m as ms l) v -> (v,a,m,as,ms);
                                                Failure (State a m as ms l) -> (-1,a,m,as,ms)
                                               }


