module Aufgabe8 where

import List



data Expr = Id String | Apply Expr Expr | Lambda String Expr
        deriving(Show, Eq)

----


allefrei                       :: Expr -> [String] -> [String]
allefrei (Id x) xs             = xs
allefrei (Apply exp1 exp2) xs  = (allefrei exp1 xs) ++ (allefrei exp2 xs)
allefrei (Lambda x exp) xs     = x:xs


----


frei                            :: String -> Expr -> Bool
frei x e                        = not(elem x (allefrei e []))


----


diff                        	:: [String] -> String -> [String]
diff xs x                   	= if elem x xs
                                    then diff (xs \\ [x]) x
                                  else xs

----



freie                           :: Expr -> [String] -> [String]
freie (Id x) xs                 = x:xs
freie (Apply exp1 exp2) xs      = (freie exp1 xs) ++ (freie exp2 xs)
freie (Lambda x exp) xs         = diff xs x


----


neu                          	:: Expr -> Expr -> String -> String -> String -> String
neu e1 e2 x1 x2 n            	= if not(elem n (freie e1 [])) && 
                                     not(elem n (freie e2 [])) &&
                                     not(n == x1) && not(n == x2)
                                    then n
                                    else neu e1 e2 x1 x2 ('a':n)
                                    
----



replace                         :: Expr -> String -> Expr -> Expr
replace e x1 (Id x2) 
    | x1 == x2                  = e 
    | otherwise                 = Id x2
replace e1 x (Apply e2 e3)      = Apply (replace e1 x e2)(replace e1 x e3)
replace e1 x1 (Lambda x2 e2)    
    | x1 == x2                  = Lambda x2 e2
    | not(x1 == x2) && 
      not(frei x2 e1)           = Lambda x2 (replace e1 x1 e2)
    | otherwise                 = Lambda (neu e1 e2 x1 x2 "b")
                                    (replace e1 x1 (replace (Id (neu e1 e2 x1 x2 "b")) x2 e2))


----


reduce                          :: Expr -> Expr
reduce (Apply (Lambda x e1) e2) = reduce(replace e2 x e1)
reduce (Lambda x1 (Apply e (Id x2))) 
    | x1 == x2 &&                 
      not(frei x1 (Lambda x1 (Apply e (Id x2))))
                                = reduce e
reduce (Apply e1 e2)            = Apply (reduce e1)(reduce e2)
reduce e                        = e
    


