module Aufgabe6 where


---------class-Sorted-------------------

class Sorted s where
      sortIncr :: (Ord a) => s a -> s a
      sortDecr :: (Ord a) => s a -> s a
-----------------------------------------



-------sorted list ----------------------
instance Sorted [] where
      sortIncr [] = []
      sortIncr (x:xs) = sortIncr [y|y<-xs, y<x] ++ [x] ++ sortIncr [y|y<-xs, y>=x]
      sortDecr xs = reverse (sortIncr xs)
-----------------------------------------




--------sorted tree----------------------
data Tree a = Leaf a | Branch (Tree a) (Tree a) deriving (Eq, Show)

instance Sorted Tree where
      sortIncr t = toTree (sortIncr (toList t))
      sortDecr t = toTree (sortDecr (toList t))
-----------------------------------------
toList :: Tree a -> [a]
toList (Leaf x) = [x]
toList (Branch x y) = (toList x) ++ (toList y)

toTree :: [a] -> Tree a
toTree [x] = Leaf x
toTree xs = Branch (toTree (take (div (length xs) 2) xs)) (toTree (drop (div (length xs) 2) xs))
-----------------------------------------


testTree = Branch (Branch (Leaf 10) (Branch (Leaf 2) (Leaf 7))) (Branch (Branch (Leaf 4) (Leaf 1)) (Leaf 6))



--------------student--------------------
data Student = Student String String Integer deriving Show

instance Eq Student where
      (==) (Student nam1 dat1 mn1) (Student nam2 dat2 mn2) = mn1 == mn2

instance Ord Student where
      (<) (Student nam1 dat1 mn1) (Student nam2 dat2 mn2) = mn1 < mn2
      (>) (Student nam1 dat1 mn1) (Student nam2 dat2 mn2) = mn1 > mn2
      (<=) (Student nam1 dat1 mn1) (Student nam2 dat2 mn2) = mn1 <= mn2
      (>=) (Student nam1 dat1 mn1) (Student nam2 dat2 mn2) = mn1 >= mn2
----------------------------------------


testStudents = [Student "Zweng" "29.06.1979" 9726302,Student "Berger" "1.1.1950" 7034531,Student "Egger" "11.4.1975" 9425123,Student "Meister" "11.11.1981" 0123456]


