module Aufgabe10 where


---- Statusinformationen:
---- Koordinate1, Koordinate2, Blickwinkel, Status des Stifts

type State = (Integer, Integer, Int, Bool)




---- Roboterstatus

data Roboter a = Roboter (State -> (a, State))

instance Monad Roboter where
  Roboter oldstate >>= fun = 
    Roboter (\s0 -> let (a, newstate) = oldstate s0
                        Roboter newbot = fun a 
                    in newbot newstate)

  return k = Roboter(\s -> (k, s))




---- Monad primitives

getpen :: State -> Bool
getpen (x, y, d, p) = p

setpen :: State -> Bool -> State
setpen (x, y, d, p) np = (x, y, d, np)

getpos :: State -> (Integer, Integer)
getpos (x, y, d, p) = (x, y)

setpos :: State -> (Integer, Integer) -> State
setpos (x, y, d, p) (nx, ny) = (nx, ny, d, p)

walk :: State -> Integer -> State
walk (x, y, d, p) k 
  | d ==   0  = (x + k, y    , d, p)
  | d ==  90  = (x    , y - k, d, p)
  | d == 180  = (x - k, y    , d, p)
  | d == 270  = (x    , y + k, d, p)

getdir :: State -> Int
getdir (x, y, d, p) = d

setdir :: State -> Int -> State
setdir (x, y, d, p) nd 
  | nd < 0    = setdir (x, y, d, p) (nd + 360)
  | nd > 270  = setdir (x, y, d, p) (nd - 360)
  | otherwise = (x, y, nd, p)




---- Stift senken, return wenn er schon gesenkt war

down :: Roboter Bool
down = Roboter (\s -> (getpen s, setpen s True))



---- Stift heben

up :: Roboter Bool
up = Roboter (\s -> (getpen s, setpen s False))




---- K schritte vorwaerts

move :: Integer -> Roboter (Integer, Integer)
move k = Roboter (\s -> (getpos s, walk s k))



---- bewgung zu angegebener Koordinate

moveTo :: (Integer, Integer) -> Roboter (Integer, Integer)
moveTo (x, y) = Roboter (\s -> (getpos s, setpos s (x, y)))



---- rotation (uhrzeigersinn, 90 grad-schritte)

turn :: Int -> Roboter Int
turn d = Roboter (\s -> (getdir s, setdir s ((getdir s) + d)))
   
         


---- bestimmte blickrichtung (winkel) setzen

turnTo :: Int -> Roboter Int
turnTo d = Roboter (\s -> (getdir s, setdir s d))     




---- staus holen

getstate :: (a, State) -> State
getstate (a, s) = s




---- gib ergebniszustand zurck

simulate :: Roboter a -> (Integer, Integer, Int, Bool)
simulate (Roboter r) = getstate (r (0, 0, 0, False))       


