#include <iostream>
using namespace std;


int strl( const char *s) {
	if (!s) return 0;
	int l=0;
	while (s[l]) ++l;
	return l;
}

class String {

	char * text;

	public:
  		String();
  		String( const char * );
		String( const String& );
		~String() {delete [] text;} 
  		void print() const { cout << text; }
  		String& operator=( const String& );
		String operator+( const String& ) const;
};


String::String() :text(new char[1]) { *text='\0'; }


String::String( const char * t ) :text(new char[strl(t)+1]) {  // mit Absicherung auf &Uuml;berlauf
	int i;
	for (i=0; i<strl(t); i++) *(text+i)=*(t+i);
	*(text+i)='\0';
}

String::String( const String& s) :text(new char[strl(s.text)+1]) {
	int i, length=strl(s.text);
	for (i=0; i<length; i++) *(text+i)=*(s.text+i);
	*(text+i)='\0';
}

String& String::operator=( const String& s ) {
  	delete [] text;
	text=new char[strl(s.text)+1];
	int i;
	for (i=0; i<strl(s.text); i++) *(text+i)=*(s.text+i);
	*(text+i)='\0';

	return *this;
}

String String::operator+( const String& s ) const {
	String help;
	int i, j, length1=strl(text), length2=strl(s.text);
	help = new char[length1+length2+1];
	
	for (i=0; i<length1; i++) *(help.text+i)=*(text+i);
	for (j=0; j<length2; j++, i++) *(help.text+i)=*(s.text+j);
	*(help.text+i)='\0';
	return help;
}

int main() {
  	String a( "Hugo" );
  	String b( "Franz" );
  	String c( "Karl" );

	cout << endl;
  	a.print(); cout << endl;
  	b.print(); cout << endl;
  	c.print(); cout << endl;

  	a = b = c;

  	a.print(); cout << endl;
  	b.print(); cout << endl;
  	c.print(); cout << endl;

  	a = b = "Wieso?";

  	a.print(); cout << endl;
  	b.print(); cout << endl;
  	c.print(); cout << endl;


	cout << "OPERATOR +" << endl;
	String x="xy";
	String y="za";
	String z;
	z=x+y;
	cout << "x: "; x.print(); cout << endl;
	cout << "y: "; y.print(); cout << endl;
	cout << "z=x+y: "; z.print(); cout << endl;


	cout << "COPYCONSTRUCTOR" << endl;
	String d=c;
	cout << "c: "; c.print(); cout << endl;
	cout << "d=c: "; d.print(); cout << endl;


  	return 0;
}

	
