/* Aufgabe 5a.3 :: <name> :: <matr-nr> */

#include <iostream>
using namespace std;

const int index = 500; //Anzahl der mglichen Eintrge
const int len = 80; //max. Lnge des jeweiligen Eintrags

char interpret[index][len];
char album[index][len];
char stil[index][len];

bool belegt[index] = {false}; //gibt an, ob ein Index belegt ist oder nicht


/* (1) Neuen Eintrag anlegen */

void neuEintrag() {
     
     system("clear");
     
     char neuInterpret[len];
     char neuAlbum[len];
     char neuStil[len];
     
     cout << "**********************************************************" << endl;  
     cout << "* Bitte geben Sie den Namen des Interpreten ein: ";
     cin >> neuInterpret;
     cout << "* Bitte geben Sie den Namen des Albums ein: ";
     cin >> neuAlbum;
     cout << "* Bitte geben Sie die Musikrichtung ein: ";
     cin >> neuStil;
     cout << "******************" << endl;
     
     //nun wird der neue Eintrag in den globalen Arrays gespeichert
     
     for (int i=0; i<index; i++) {
         
             if (!belegt[i]) { //falls an der Stelle i noch kein Eintrag vorhanden
                           
                for (int j=0; j<len; j++) {
                    
                    interpret[i][j] = neuInterpret[j]; 
                    album[i][j] = neuAlbum[j];
                    stil[i][j] = neuStil[j];
                    
                } //for (j)
                
                belegt[i] = true; //Index i ist nun belegt
                cout << "* Ihr Eintrag wurde mit dem Index " << i << " gespeichert." << endl;
                cout << "**********************************************************" << endl << endl;
                break;
             } // if         
                
     } //for (i)    

} //neuEintrag


/* (2) Eintrag bearbeiten */         

void bearbeiten() {
     
     system("clear");
     
     int select;
     int edit;
     bool repeat = true;
     
     cout << "**********************************************************" << endl;
     cout << "* Welchen Eintrag moechten Sie bearbeiten?" << endl;
     cout << "* Geben Sie bitte die Indexnummer ein: ";
     cin >> edit;
     cout << "*" << endl;

     if (!belegt[edit]) cout << "* An dieser Stelle ist kein Eintrag vorhanden." << endl << "**********************************************************" << endl;
     
     else {
          
          cout << "* Der gewaehlte Eintrag ist folgender: " << endl;
          cout << "* (" << edit << ") " << interpret[edit] << " - " << album[edit] << " (" << stil[edit] << ")" << endl;
          
          
          do {
              
              cout << "**********************************************************" << endl;
              cout << "* Was wollen Sie an dem Eintrag aendern? "<< endl;
              cout << "* (1) Interpret" << endl;
              cout << "* (2) Albumtitel" << endl;
              cout << "* (3) Musikrichtung" << endl;
              cout << "* (4) Komplett Loeschen" << endl;
              cout << "* (5) Doch nichts (zurueck)" << endl;
              cout << "* ";
              cin >> select;
              cout << "**********************************************************" << endl;
              
              switch (select) {
                     
                     case 1: cout << "* Bitte geben Sie den neuen Namen des Interpreten ein: ";
                             cin >> interpret[edit];
                             break;
                             
                     case 2: cout << "* Bitte geben Sie den neuen Namen des Albums ein: ";
                             cin >> album[edit];
                             break;
                             
                     case 3: cout << "* Bitte geben Sie die neue Musikrichtung ein: ";
                             cin >> stil[edit];
                             break;
                             
                     case 4: for (int i=0; i<len; i++) {
                                 interpret[edit][i] = '\0';
                                 album[edit][i] = '\0';
                                 stil[edit][i] = '\0';
                             } //for
                             belegt[edit] = false;
                             cout << "* Der Eintrag wurde geloescht!" << endl << "**********************************************************";
                             repeat = false;
                             break;
                             
                     case 5: repeat = false;
                             break;
                   
                     default: cout << "* Falsche Eingabe!" << endl << "**********************************************************"; break;
                     
              } //switch
                                      
          } while (repeat); //do
     
          cout << "**********************************************************" << endl;
     
     } //else

     if (belegt[edit]) {
                                     
        cout << "* Der Eintrag lautet jetzt: " << endl;
        cout << "* (" << edit << ") " << interpret[edit] << " - " << album[edit] << " (" << stil[edit] << ")" << endl << endl;
        cout << "**********************************************************" << endl;
     } //if
          
} //bearbeiten


/* (3) Einen Eintrag suchen */

void suchen() {
     
     system("clear");
     
     char suche[len];
     int count=0;    
     
     cout << "**********************************************************" << endl;
     cout << "* Geben Sie ein Schlagwort ein, nachdem Sie suchen wollen: ";
     cin >> suche;
     cout << "**********************************************************" << endl;
     cout << "* Folgende Eintraege wurden gefunden: " << endl;
     cout << "**********************************************************" << endl;    
     
     for (int i=0; i<index; i++) { //Durchsuchen der Arrays
 
         count = 0;
     
         for (int j=0; suche[j]; j++) { //Suche nach Interpreten
             
             if (suche[j]==interpret[i][j]) count++;
                      
             else break;
        
         } //for Interpret (j)
         
         if (count==strlen(suche) && count==strlen(interpret[i])) {
            cout << "* (" << i << ") " << interpret[i] << " - " << album[i] << " (" << stil[i] << ")" << endl;
         } //if
                     
         count = 0;
         
         for (int j=0; suche[j]; j++) { //Suche nach Alben
         
             if (suche[j]==album[i][j]) count++;
                          
             else break;
         
         } // for Album (j)
         
         if (count==strlen(suche) && count==strlen(album[i])) {
            cout << "* (" << i << ") " << interpret[i] << " - " << album[i] << " (" << stil[i] << ")" << endl;
         } //if
         
         count = 0;
         
         for (int j=0; suche[j]; j++) { //Suche nach Stil
         
             if (suche[j]==stil[i][j]) count++;
                          
             else break;
         
         } // for Stil (j)
         
         if (count==strlen(suche) && count==strlen(stil[i])) {
            cout << "* (" << i << ") " << interpret[i] << " - " << album[i] << " (" << stil[i] << ")" << endl;
         } //if
         
     } //for (i)   
     
     cout << "**********************************************************" << endl;
     
} //suchen     
                                            

/* (4) Alle Eintraege anzeigen */

void anzeigen() {
     
     system("clear");
     
     int count=0;
     
     cout << "**********************************************************" << endl;
     cout << "** Sie haben folgende Eintraege angelegt: " << endl;
     cout << "**********************************************************" << endl;
     
     for (int i=0; i<index; i++) {
         
         if (belegt[i]) { //falls Eintrag vorhanden
            cout << "* (" << i << ") " << interpret[i] << " - " << album[i] << " (" << stil[i] << ")" << endl;
            count++;
         } //if 
     
     } //for
     
     cout << "**********************************************************" << endl;
     cout << "* Insgesamt " << count << " Eintraege." << endl;
     cout << "**********************************************************" << endl;

} //anzeigen


/* main */
                      
int main() {
    
    system("clear");
       
    bool restart = true;
       
    while(restart) {
        
        int select;
           
        cout << endl << "**********************************************************" << endl;
        cout << "************ CD Verwaltungssoftware 0.72 beta ************" << endl;
        cout << "**********************************************************" << endl << "*" << endl;
        cout << "* Was wollen Sie tun? " << endl << "*" << endl;
        cout << "*(1) Neuen Eintrag anlegen" << endl;
        cout << "*(2) Eintrag bearbeiten" << endl;
        cout << "*(3) Einen Eintrag suchen" << endl;
        cout << "*(4) Alle Eintraege anzeigen" << endl;
        cout << "*(5) Beenden" << endl;
        cout << "* ";
        cin >> select;
        
        switch (select) {
               case 1: neuEintrag(); break;
               case 2: bearbeiten(); break;
               case 3: suchen(); break;
               case 4: anzeigen(); break;
               case 5: restart = false; break;
               default: cout << endl << "* Falsche Eingabe"; break;
        } //switch
        
    } // while
    cout << "**********************************************************" << endl;
    cout << "**************** Bis zum naechsten Mal :-)****************" << endl;
    cout << "**********************************************************" << endl;
    
    return 0;
} // main
