public class Image 
{
		
	// zweidimensionales Array, das die Bilddaten enthält
	private char [][] bild;
	
	
	// Konstruktor
	// Bilddaten werden übergeben und gespeichert
	public Image (char[][] bild) 
	{
		this.bild = bild;
	}
	
	
	// Öffentliche Füll-Methode
	// Startposition und Zeichen, mit dem gefüllt werde soll, wird übergeben
	public int fill(int zeile, int spalte, char neuesZeichen) 
	{
		// überprüfen, ob die Startposition außerhalb des Bildes liegt
		if (zeile < 0 || spalte < 0 || zeile >= bild.length || spalte >= bild[zeile].length)
			return 0;		
		
		// eigentliche Füll-Methode aufrufen
		return fill(zeile, spalte, neuesZeichen, bild[zeile][spalte]);
	}
	
	
	// private, rekursive Füll-Methode
	//
	// Zeile i 
	// Spalte j
	// neuesZeichen: Zeichen, mit dem gefüllt wird
	// altesZeichen: Zeichen, das ersetzt werden soll
	//
	// retourniert, wie viele Zeichen mit dem Aufruf der Funktion gefüllt wurden
	private int fill(int i, int j, char neuesZeichen, char altesZeichen) 
	{
		
		// überprüfen, ob die Position außerhalb des Bildes liegt
		// Wenn ja, wird nichts geändert und somit 0 retourniert.
		if (i < 0 || j < 0 || i >= bild.length || j >= bild[i].length)
			return 0;
		
			
		// überprüfen, ob das zu ersetzende Zeichen das korrekte Zeichen ist,
		// d.h. es hat dieselbe Farbe wie das erste gefüllte Zeichen und wurde
		// noch nicht in einem anderen Funktionsaufruf gefüllt.
		if (bild[i][j] == altesZeichen )
		{
			
			// das aktuelle Zeichen wird gefüllt
			bild[i][j] = neuesZeichen;		
			
			
			// Rekursion: Für die vier Nachbarn des aktuellen Zeichen wird wieder
			// diese Funktion aufgerufen (in der wiederum überprüft wird, ob die
			// Position innerhalb des Bildes liegt, das Zeichen das korrekte Zeichen 
			// ist und somit gefüllt wird und die nächste Rekursion mit dessen 
			// Nachbarn startet... etc)
									
			int   oben = fill(i-1, j,   neuesZeichen, altesZeichen);			
			int  unten = fill(i+1, j,   neuesZeichen, altesZeichen);			
			int  links = fill(i,   j-1, neuesZeichen, altesZeichen);			
			int rechts = fill(i,   j+1, neuesZeichen, altesZeichen);			
			
			
			// Zeichen, das soeben gefüllt wurde plus
			// Anzahl der geänderten Zeichen der Nachbarfelder
			return 1 + oben + unten + links + rechts;
		} 

		else return 0;
	}
	
	
	// Bildausgabe - beim Cast in einen String wird in zwei Schleifen das Bild 
	// als String retourniert.
	public String toString () 
	{
		String ret = "";
		
		
		for (int i = 0; i<bild.length; i++) 
		{
			for (int j = 0; j<bild[i].length; j++) 
			{
				ret += bild[i][j];
			}
			ret += "\n";
		}
		ret += "\n";		
		
		return ret;
	}
	
}
