
// Klasse DHSimpleHashSet oder SCSimpleHashSet oder LinkedList

   /**
    * Fgt alle Werte aus der angegebenen java.util.Collection in diese Datenstruktur ein.
    *
    * @return true falls in diese Datenstruktur mindestens ein Element hinzugefgt wurde.
    *
    * @throws NullPointerException falls c null ist.
    */
   public boolean addAll(java.util.Collection c) {
      //
      // Variante: wenn der Rckgabetyp nicht boolean, sondern void ist,
      // dann gengt einfach:
      //
      //    for(java.util.Iterator it = c.iterator(); it.hasNext(); ) {
      //       this.add(it.next());
      //    }
      //
      boolean einEinfgenErfolgreich = false;
      for(java.util.Iterator it = c.iterator(); it.hasNext(); ) {
         if (this.add(it.next())) {
            einEinfgenErfolgreich = true;
         }
      }
      return einEinfgenErfolgreich;
   }

   /**
    * Entfernt alle Werte, die in der angegebenen java.util.Collection enthalten sind,
    * aus dieser Datenstruktur.
    *
    * @return true falls aus dieser Datenstruktur mindestens ein Element entfernt wurde.
    *
    * @throws NullPointerException falls c null ist.
    */
   public boolean removeAll(java.util.Collection c) {
      //
      // Variante: wenn der Rckgabetyp nicht boolean, sondern void ist,
      // dann gengt einfach:
      //
      //    for(Object o : c) {
      //       this.remove(o);
      //    }
      //
      boolean einEntfernenErfolgreich = false;
      for(Object o : c) {
         if (this.remove(o)) {
            einEntfernenErfolgreich = true;
         }
      }
      return einEntfernenErfolgreich;
   }
