
// Klasse Emailverzeichnis

   /**
    * Liefert alle Eintrge aus diesem Directory als XML-Dokument.
    *
    * Das Format des XML-Dokuments ist durch die DTD
    * http://www.pri.univie.ac.at/~bruckmann/lehre_ss05/aufg/map.dtd
    * vorgegeben.
    */
   public String toXml() {
      StringBuffer xmlSb = new StringBuffer();
      final String NEWLINE = System.getProperty("line.separator");

      xmlSb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?>").append(NEWLINE)
           .append("<!DOCTYPE map").append(NEWLINE)
           .append("          SYSTEM \"http://www.pri.univie.ac.at/~bruckmann/lehre_ss05/aufg/map.dtd\">").append(NEWLINE)
           .append("<map>").append(NEWLINE)
           .append("<lastSavedBy name=\"" + System.getProperty("user.name") + "\" />").append(NEWLINE).append(NEWLINE);
      for (java.util.Iterator<java.util.Map.Entry> it = map.entrySet().iterator(); it.hasNext(); ) {
         java.util.Map.Entry e = it.next();
         xmlSb.append("   <entry key=\"" + e.getKey() + "\">").append(NEWLINE)
              .append("      <value>" + e.getValue() + "</value>").append(NEWLINE)
              .append("   </entry>").append(NEWLINE).append(NEWLINE);
      }
      xmlSb.append("</map>").append(NEWLINE);
      return xmlSb.toString();
   }

   /**
    * Schreibt die Eintrge aus diesem Directory als XML-Dokument in eine Datei.
    *
    * Das Format des XML-Dokuments ist durch die DTD
    * http://www.pri.univie.ac.at/~bruckmann/lehre_ss05/aufg/map.dtd
    * vorgegeben.
    * 
    * @param f die Ausgabedatei, in die das XML-Dokument geschrieben werden soll.
    *
    * @throws java.io.IOException wenn ein Fehler beim Schreiben der Datei auftritt.
    */
   public void writeXmlToFile(java.io.File f) throws java.io.IOException {
      /* oder einfacher mit einem java.io.FileWriter */
      java.io.FileOutputStream   fos = null;
      java.io.OutputStreamWriter osw = null;
      java.io.BufferedWriter     bw  = null;
      java.io.PrintWriter        pw  = null;
      try {
         fos = new java.io.FileOutputStream(f);
         osw = new java.io.OutputStreamWriter(fos);
         bw  = new java.io.BufferedWriter(osw);
         pw  = new java.io.PrintWriter(bw);
         pw.println(this.toXml());
         pw.flush();
      /* wir haben hier KEINEN catch-Block;              */
      /* eine allfllige java.io.IOException soll        */
      /* (nach Ausfhrung des finally-Blocks) an das     */
      /* aufrufende Programmstck weitergegeben werden.  */
      } finally {
         if (pw  != null) pw.close();
         try {
            if (bw  != null) bw.close();
         } catch(java.io.IOException e) {
            /* wir ignorieren diese Exception */
         }
         try {
            if (osw != null) osw.close();
         } catch(java.io.IOException e) {
            /* wir ignorieren diese Exception */
         }
         try {
            if (fos != null) fos.close();
         } catch(java.io.IOException e) {
            /* wir ignorieren diese Exception */
         }
      }
   }
