
/**
 * Die Klasse TransaktionenApp ermittelt empirisch die Laufzeit
 * des Suchens in verschiedenen Datenstrukturen.
 *
 * @author Clemens Bruckmann
 *
 * @version 2005-03-16
 */
public class TransaktionenApp {


   public static void main(String[] args) {

      /* Als Datenstruktur fr die Menge der gesperrten           */
      /* Kreditkarten wird nacheinander zunchst eine LinkedList, */
      /* dann ein TreeSet und zuletzt ein HashSet verwendet.      */

      ermittleLaufzeit(new java.util.LinkedList<Kreditkarte>());
      ermittleLaufzeit(new java.util.TreeSet<Kreditkarte>());
      ermittleLaufzeit(new java.util.HashSet<Kreditkarte>(5000));

   }


   /**
    * @param gesperrteKreditkarten die Datenstruktur, in der wiederholt gesucht werden soll.
    */
   protected static void ermittleLaufzeit(java.util.Collection<Kreditkarte> gesperrteKreditkarten) {
      long timeStart, timeEnd;
      System.out.println("Ermittle Laufzeit fr Datenstruktur " +
                         gesperrteKreditkarten.getClass().getName());
      java.io.FileInputStream   fis = null;
      java.io.InputStreamReader isr = null;
      java.io.BufferedReader    br  = null;
      int anzahlDerUngltigenZeilen = 0;
      try {
         System.out.print("   Vorbereitung: Lade gesperrte Kreditkarten aus Datei ... ");
         fis = new java.io.FileInputStream(new java.io.File("gesperrteKreditkarten.txt"));
         isr = new java.io.InputStreamReader(fis);
         br  = new java.io.BufferedReader(isr);
         for (String zeile = br.readLine();
              zeile != null;
              zeile = br.readLine()) {
            zeile = zeile.trim();
            if (!(zeile.equals("") || zeile.charAt(0) == '#')) {     // Leer- oder Kommentarzeile
               int positionDesStrichpunkts = zeile.indexOf(';');
               if (positionDesStrichpunkts == -1) {
                  /* es gibt keinen Strichpunkt => ungltige Zeile */
                  anzahlDerUngltigenZeilen = anzahlDerUngltigenZeilen + 1;
               } else {
                  /* Zeile mit gltigem Eintrag */
                  gesperrteKreditkarten.add(new Kreditkarte(
                           zeile.substring(0, positionDesStrichpunkts).trim(),
                           Integer.parseInt(zeile.substring(positionDesStrichpunkts + 1).trim())));
               }
            }
         }
         System.out.println("fertig.");
         if (anzahlDerUngltigenZeilen > 0) {
            System.out.println("   " + anzahlDerUngltigenZeilen +
                               " ungltige Zeilen bersprungen.");
         }
         System.out.println("   " + gesperrteKreditkarten.size() +
                            " gesperrte Kreditkarten in der Datenstruktur.");
         // VORBEREITUNG FERTIG

         System.out.print("   Suche Transaktionen mit gesperrten Kreditkarten ... ");
         anzahlDerUngltigenZeilen = 0;
         int anzahlSearchMisses    = 0,
             anzahlSearchHits      = 0;
         fis = new java.io.FileInputStream(new java.io.File("Kreditkartentransaktionen.txt"));
         isr = new java.io.InputStreamReader(fis);
         br  = new java.io.BufferedReader(isr);
         timeStart = System.currentTimeMillis();
         /* ein aussagekrftigeres Messergebnis kann erzielt werden,   */
         /* wenn die Dateieingabe-Operationen nicht mitgemessen werden */
         /* Nachteil dabei aber: alle 100000 Transaktionen mssten     */
         /* auf ein Mal im Speicher gehalten werden oder die Messung   */
         /* msste in mehreren Teilen erfolgen                         */
         for (String zeile = br.readLine();
              zeile != null;
              zeile = br.readLine()) {
            zeile = zeile.trim();
            if (!(zeile.equals("") || zeile.charAt(0) == '#')) {     // Leer- oder Kommentarzeile
               int positionDesStrichpunkts = zeile.indexOf(';');
               if (positionDesStrichpunkts == -1) {
                  /* es gibt keinen Strichpunkt => ungltige Zeile */
                  anzahlDerUngltigenZeilen = anzahlDerUngltigenZeilen + 1;
               } else {
                  /* Zeile mit gltigem Eintrag */
                  /* hier erfolgt jetzt die Suche in der Datenstruktur! */
                  if(gesperrteKreditkarten.contains(new Kreditkarte(
                           zeile.substring(0, positionDesStrichpunkts).trim(),
                           Integer.parseInt(zeile.substring(positionDesStrichpunkts + 1).trim())))) {
                     anzahlSearchHits = anzahlSearchHits + 1;
                  } else {
                     anzahlSearchMisses = anzahlSearchMisses + 1;
                  }
               }
            }
         }
         timeEnd = System.currentTimeMillis();
         System.out.println("fertig.");
         if (anzahlDerUngltigenZeilen > 0) {
            System.out.println("   " + anzahlDerUngltigenZeilen +
                               " ungltige Zeilen bersprungen.");
         }
         System.out.println("   " + anzahlSearchHits +
                            " illegale Transaktionen gefunden (" +
                            (anzahlSearchHits + anzahlSearchMisses) +
                            " Transaktionen insgesamt)");
         System.out.println("Bentigte Zeitdauer: " + (timeEnd - timeStart) + " ms.");
      } catch(java.io.IOException e) {
         System.out.println("\nFehler bei der Dateieingabe: " + e.getLocalizedMessage());
      } finally {
         try {
            if (br  != null) br.close();
         } catch(java.io.IOException e) {
            /* wir ignorieren diese Exception */
         }
         try {
            if (isr != null) isr.close();
         } catch(java.io.IOException e) {
            /* wir ignorieren diese Exception */
         }
         try {
            if (fis != null) fis.close();
         } catch(java.io.IOException e) {
            /* wir ignorieren diese Exception */
         }
      }
   }

}
