
/**
 * Die Klasse SCSimpleHashSet verwaltet eine Menge von Objekten
 * mittels einer Hashtabelle mit separate chaining.
 *
 * Der Wert null ist als Eintrag nicht zulssig.
 *
 * @author Clemens Bruckmann
 *
 * @version 2005-03-09
 */
public class SCSimpleHashSet {

   /**
    * Die Hashtabelle.
    */
   protected java.util.List[] hashtabelle;

   /**
    * Konstruktor.
    * Legt die Gre der Hashtabelle mit 101 fest.
    */
   public SCSimpleHashSet() {
      this(101);
   }

   /**
    * Konstruktor.
    *
    * @param size die Gre der Hashtabelle.
    */
   public SCSimpleHashSet(int size) {
      hashtabelle = new java.util.List[size];
   }

   /**
    * Fgt das angegebene Objekt in diese Menge ein.
    * Falls es bereits enthalten war, bleibt die Menge unverndert.
    *
    * @return true  falls das eingefgte Objekt vorher nicht enthalten war;
    *         false falls das Objekt nicht eingefgt wurde,
    *               da es bereits enthalten war.
    *
    * @throws IllegalArgumentException falls das als Parameter
    *                                  angegebene Objekt null ist.
    */
   public boolean add(Object o) {
      if (o == null) throw new IllegalArgumentException();
      int tabellenplatz = Math.abs(o.hashCode() % hashtabelle.length);
      if (hashtabelle[tabellenplatz] == null) {
         hashtabelle[tabellenplatz] = new java.util.LinkedList();
      }
      if (hashtabelle[tabellenplatz].contains(o)) {
         return false;
      } else {
         hashtabelle[tabellenplatz].add(o);
         return true;
      }
   }

   /**
    * Gibt an, ob das angegebene Objekt in dieser Menge enthalten ist.
    *
    * @return true falls das angegebene Objekt in dieser Menge enthalten ist.
    */
   public boolean contains(Object o) {
      /* null kann nicht eingefgt werden und kann daher nicht enthalten sein */
      if (o == null) return false;
      int tabellenplatz = Math.abs(o.hashCode() % hashtabelle.length);
      return hashtabelle[tabellenplatz] != null &&
             hashtabelle[tabellenplatz].contains(o);
   }

   /**
    * Entfernt das angegebene Objekt aus dieser Menge, falls es enthalten ist.
    *
    * @return true falls das Objekt vorher enthalten war.
    */
   public boolean remove(Object o) {
      /* null kann nicht eingefgt werden und kann daher nicht enthalten sein */
      if (o == null) return false;
      int tabellenplatz = Math.abs(o.hashCode() % hashtabelle.length);
      return hashtabelle[tabellenplatz] != null &&
             hashtabelle[tabellenplatz].remove(o);
   }

}
