public class LinkedList implements List, Iterable {

   // alles brige wie bisher ...

   /**
    * Liefert einen Iterator ber die Elemente dieser Liste.
    *
    * Der Iterator liefert die Elemente in jener Reihenfolge, in welcher sie
    * in dieser Liste auftreten.
    *
    * Falls die Liste whrend der Iteration auf eine andere Art als mittels
    * der Methode remove() des Iterators modifiziert wird, ist das Verhalten
    * des Iterators nicht definiert.
    */
   public java.util.Iterator iterator() {
      return new LinkedListIterator();
   }

   /**
    * Die innere Klasse LinkedListIterator stellt einen Iterator
    * ber die Elemente dieser verketteten Liste dar.
    *
    * Falls die Liste whrend der Iteration auf eine andere Art als mittels
    * der Methode remove() des Iterators modifiziert wird, ist das Verhalten
    * dieses Iterators nicht definiert.
    *
    * @author Clemens Bruckmann
    *
    * @version 2005-04-06
    */
   protected class LinkedListIterator implements java.util.Iterator {

      /**
       * Das nchste vom Iterator zu liefernde Element.
       */
      protected ListNode nextNode = head;

      /**
       * Das Element vor dem zuletzt vom Iterator gelieferten Element
       * (zwei vor nextNode).
       */
      protected ListNode prevNode = null;

      /**
       * Gibt an, ob die Methode remove() derzeit aufgerufen werden kann.
       * Siehe die Beschreibung zur Methode remove().
       */
      protected boolean removable = false;

      /**
       * Liefert true falls dieser Iterator noch weitere Elemente bereithlt.
       *
       * Falls die Liste whrend der Iteration auf eine andere Art als mittels
       * der Methode remove() des Iterators modifiziert wird, ist das Verhalten
       * dieses Iterators nicht definiert.
       */
      public boolean hasNext() {
         return nextNode != null;
      }

      /**
       * Liefert das nchste Element.
       *
       * @throws java.util.NoSuchElementException falls es keine weiteren
       *                                          Elemente gibt.
       */
      public Object next() {
         if (nextNode == null) throw new java.util.NoSuchElementException();
         // prevNode auf das Element zwei vor der neuen Position von nextNode setzen
         if      (nextNode == head)      prevNode = null;
         else if (nextNode == head.next) prevNode = head;
         else                            prevNode = prevNode.next;
         removable = true;
         Object retval = nextNode.value;
         nextNode = nextNode.next;
         return retval;
      }

      /**
       * Entfernt das zuletzt von der Methode next() gelieferte Element aus
       * der verketteten Liste. Nach jedem Aufruf der Methode next() kann
       * die Methode remove() maximal ein Mal aufgerufen werden.
       *
       * Falls die Liste whrend der Iteration auf eine andere Art als mittels
       * der Methode remove() des Iterators modifiziert wird, ist das Verhalten
       * dieses Iterators nicht definiert.
       *
       * @throws IllegalStateException falls die Methode next() noch nicht
       *                               aufgerufen wurde oder falls die Methode
       *                               remove() bereits einmal nach dem letzten
       *                               Aufruf der Methode next() aufgerufen wurde.
       */
      public void remove() {
         if (!removable) throw new IllegalStateException();
         // nextNode bleibt unverndert
         removable = false;
         if (prevNode == null) head = head.next;   // das erste Element entfernen
         else                  prevNode.next = prevNode.next.next;   // weiteres Element entfernen
         if (nextNode == null) prevNode = null;   // Listenende erreicht, Speicher freigeben
      }
   }

}
