
/**
 * Das Programm GraphTestApp testet die Graphen.
 *
 * @author Clemens Bruckmann
 *
 * @version 2005-05-25
 */
public class GraphTestApp {

   public static void main(String[] args) {
      Graph am = new AdjMatrixGraph(5, true);
      Graph al = new AdjListGraph(5, true);
      char menubefehl = ' ';
      char menubeispiel =' ';
      java.io.BufferedReader tastatur = new java.io.BufferedReader(new java.io.InputStreamReader(System.in));
      try {
      do {
         System.out.println("\nBitte whlen Sie aus:\n");
         System.out.println("\t[n] Neuen Graphen anlegen");
         System.out.println("\t[v] Anzahl der Knoten abfragen");
         System.out.println("\t[a] Bezeichnung des Knotens setzen");
         System.out.println("\t[b] Bezeichnung des Knotens abfragen");
         System.out.println("\t[k] Kante setzen");
         System.out.println("\t[e] Abfragen, ob Kante existiert");
         System.out.println("\t[w] Kantengewicht abfragen");
         System.out.println("\t[r] Kante entfernen");
         System.out.println("\t[l] Graphen aus Datei einlesen");
         System.out.println("\t[s] Graphen in Datei speichern");
         System.out.println("\t[p] Graphen auf Bildschirm ausgeben");
         System.out.println("\t[f] Graphen finden");
	 System.out.println("\t[z] (a-e)-Beispielgraphen");
	 System.out.println("\t[c] Krzesten Pfad bestimmen");

         System.out.println("\t[x] Programm beenden");

         System.out.print("\nIhre Wahl: ");
         String eingabe = tastatur.readLine();
         System.out.println();
         if (eingabe.equals("")) {
            System.out.println("Bitte whlen Sie einen gltigen Menbefehl aus.");
         } else {
            menubefehl = eingabe.charAt(0);
            try {
            switch(menubefehl) {

               case 'n':
               // NEUEN GRAPHEN ANLEGEN
                  {
                  System.out.print("Wie viele Knoten? ");
                  int v = Integer.parseInt(tastatur.readLine());
                  System.out.print("gerichtet (j/n)? ");
                  boolean directed = tastatur.readLine().equals("j");
                  am = new AdjMatrixGraph(v, directed);
                  al = new AdjListGraph(v, directed);
                  }
                  break;

		case 'c':
               // NEUEN GRAPHEN ANLEGEN
                  {
                  	System.out.print("Startknoten? ");
                  	int v = Integer.parseInt(tastatur.readLine());
		  	double[] test=am.ssspp(v);
		  	int ab =test.length/2;
			for (int i =0; i<ab;++i) 
		  	{
				System.out.println("von "+v+" ueber "+test[i+ab]+" nach "+i+" = "+test[i]);
			}
			  
		  }
                  break;

		case 'z':
		  
               // Beispielgraph
                  {
			System.out.println("Bitte geben Sie den Graphen an:");
			int v = Integer.parseInt(tastatur.readLine());
			if (v==1)
				 {
					 am=new AdjMatrixGraph(9, false);
					 am.setEdge(0, 1, 45);
					 
					 am.setEdge(1, 4, 20);
					 am.setEdge(1, 5, 55);

					 am.setEdge(2, 3, 100);
					 am.setEdge(2, 7, 140);
					 
					 am.setEdge(3, 4, 150);
					 am.setEdge(3, 6, 160);
					 
					 am.setEdge(4, 5, 50);
					 
					 am.setEdge(5, 6, 210);
					 am.setEdge(6, 8, 140);
					 am.setEdge(7, 8, 40);

					 					 



				 }
			 if (v==2)

				 {
					 am=new AdjMatrixGraph(4, true);
					 am.setEdge(0, 1, 1);
					 am.setEdge(0, 1, 1);
					 am.setEdge(1, 2, 1);
					 am.setEdge(1, 3, 1);
					 am.setEdge(2, 3, 1);
				


					 
				 }
			 if (v==3)

				 {
					 am=new AdjMatrixGraph(4, true);
					 am.setEdge(0, 1, 1);
					 am.setEdge(1, 2, 1);
				

					 
				 }
			 if (v==4)

				 {
					 am=new AdjMatrixGraph(4, true);
					 am.setEdge(0, 1, 1);
					 am.setEdge(2, 3, 1);
					 am.setEdge(0, 2, 1);
				

				 }
			 if (v==5)

				 {
					 am=new AdjMatrixGraph(4, false);
					 am.setEdge(0, 1, 1);
					 am.setEdge(2, 3, 1);
					 am.setEdge(0, 2, 1);
									 
				 }
				 }
			break;
			

               case 'v':
               // ANZAHL DER KNOTEN ABFRAGEN
                  System.out.println("Anzahl der Knoten: " + am.getNumberOfVertices());
                  System.out.println("Anzahl der Knoten: " + al.getNumberOfVertices());
                  break;

               case 'a':
               // BEZEICHNUNG DES KNOTENS SETZEN
               case 'b':
               // BEZEICHNUNG DES KNOTENS ABFRAGEN
                  {
                  System.out.print("Welcher Knotenindex? ");
                  int v = Integer.parseInt(tastatur.readLine());
                  System.out.println("Derzeitige Bezeichnung: " + am.getVertexLabel(v));
                  System.out.println("Derzeitige Bezeichnung: " + al.getVertexLabel(v));
                  if (menubefehl == 'a') {
                     System.out.print("Neue Bezeichnung: ");
                     String label = tastatur.readLine();
                     am.setVertexLabel(v, label);
                     al.setVertexLabel(v, label);
                  }
                  }
                  break;

               case 'k':
               // KANTE SETZEN
                  {
                  System.out.print("Von welchem Knotenindex? ");
                  int fromIndex = Integer.parseInt(tastatur.readLine());
                  System.out.print("Zu  welchem Knotenindex? ");
                  int toIndex = Integer.parseInt(tastatur.readLine());
                  System.out.print("Kantengewicht: ");
                  double weight = Double.parseDouble(tastatur.readLine());
                  am.setEdge(fromIndex, toIndex, weight);
                  al.setEdge(fromIndex, toIndex, weight);
                  }
                  break;

               case 'e':
               // ABFRAGEN, OB KANTE EXISTIERT
                  {
                  System.out.print("Von welchem Knotenindex? ");
                  int fromIndex = Integer.parseInt(tastatur.readLine());
                  System.out.print("Zu  welchem Knotenindex? ");
                  int toIndex = Integer.parseInt(tastatur.readLine());
                  System.out.println(am.containsEdge(fromIndex, toIndex));
                  System.out.println(al.containsEdge(fromIndex, toIndex));
                  }
                  break;

               case 'w':
               // KANTENGEWICHT ABFRAGEN
                  {
                  System.out.print("Von welchem Knotenindex? ");
                  int fromIndex = Integer.parseInt(tastatur.readLine());
                  System.out.print("Zu  welchem Knotenindex? ");
                  int toIndex = Integer.parseInt(tastatur.readLine());
                  try {
                     System.out.println("Kantengewicht: " + am.getEdgeWeight(fromIndex, toIndex));
                  } catch(IllegalStateException e) {
                     System.out.println("Kante existiert nicht");
                  }
                  try {
                     System.out.println("Kantengewicht: " + al.getEdgeWeight(fromIndex, toIndex));
                  } catch(IllegalStateException e) {
                     System.out.println("Kante existiert nicht");
                  }
                  }
                  break;

               case 'r':
               // KANTE ENTFERNEN
                  {
                  System.out.print("Von welchem Knotenindex? ");
                  int fromIndex = Integer.parseInt(tastatur.readLine());
                  System.out.print("Zu  welchem Knotenindex? ");
                  int toIndex = Integer.parseInt(tastatur.readLine());
                  System.out.println("Kante hat " +
                                     (am.removeEdge(fromIndex, toIndex) ? "existiert" : "nicht existiert"));
                  System.out.println("Kante hat " +
                                     (al.removeEdge(fromIndex, toIndex) ? "existiert" : "nicht existiert"));
                  }
                  break;

               case 'l':
               // GRAPHEN AUS DATEI EINLESEN
                  {
                  System.out.print("Dateiname: ");
                  String filename = tastatur.readLine();
                  java.io.FileReader fr = null;
                  try {
                     java.io.File f = new java.io.File(filename);
                     if (f.canRead()) {
                        fr = new java.io.FileReader(f);
                        am = new AdjMatrixGraph(new org.xml.sax.InputSource(fr));
                        fr.close();
                        fr = new java.io.FileReader(f);
                        al = new AdjListGraph(new org.xml.sax.InputSource(fr));
                        fr.close();
                        fr = null;
                     } else {
                        f = new java.io.File(filename + ".xml");
                        if (f.canRead()) {
                           fr = new java.io.FileReader(f);
                           am = new AdjMatrixGraph(new org.xml.sax.InputSource(fr));
                           fr.close();
                           fr = new java.io.FileReader(f);
                           al = new AdjListGraph(new org.xml.sax.InputSource(fr));
                           fr.close();
                           fr = null;
                        } else {
                           f = new java.io.File(filename + "_am.xml");
                           fr = new java.io.FileReader(f);
                           am = new AdjMatrixGraph(new org.xml.sax.InputSource(fr));
                           fr.close();
                           f = new java.io.File(filename + "_al.xml");
                           fr = new java.io.FileReader(f);
                           al = new AdjListGraph(new org.xml.sax.InputSource(fr));
                           fr.close();
                           fr = null;
                        }
                     }
                  } catch(java.io.IOException e) {
                     System.out.println("Fehler beim Einlesen der Datei: " + e);
                  } catch(ParseException e) {
                     System.out.println("Fehler beim Einlesen der XML-Datei: " + e);
                  } finally {
                     if (fr != null) {
                        try {
                           fr.close();
                        } catch(java.io.IOException e) {
                           /* wir ignorieren diese Exception */
                        }
                     }
                  }
                  }
                  break;

               case 's':
               // GRAPHEN IN DATEI SPEICHERN
                  {
                  System.out.print("Dateiname: ");
                  String filename = tastatur.readLine();
                  java.io.FileWriter out = null;
                  try {
                     out = new java.io.FileWriter(filename + "_al.xml");
                     out.write(al.toXgmml());
                     out.flush();
                  } catch(java.io.IOException e) {
                     System.out.println("Fehler beim Speichern in Datei " + filename + "_al.xml:\n" + e);
                  } finally {
                     try {
                        if (out != null) out.close();
                     } catch(java.io.IOException e) {
                        /* wir ignorieren diese Exception */
                     }
                  }
                  out = null;
                  try {
                     out = new java.io.FileWriter(filename + "_am.xml");
                     out.write(am.toXgmml());
                     out.flush();
                  } catch(java.io.IOException e) {
                     System.out.println("Fehler beim Speichern in Datei " + filename + "_am.xml:\n" + e);
                  } finally {
                     try {
                        if (out != null) out.close();
                     } catch(java.io.IOException e) {
                        /* wir ignorieren diese Exception */
                     }
                  }
                  }
                  break;

               case 'p':
               // GRAPHEN AUF BILDSCHIRM AUSGEBEN
                  System.out.println(am);
                  System.out.println(al);
                  break;
			case 'f':
               // GRAPHEN finden
	       	  
		  System.out.print("Bitte geben Sie den Startknoten ein! ");
                  int Startknoten = Integer.parseInt(tastatur.readLine());
		System.out.print("Bitte geben Sie den Endknoten ein! ");
		int Endknoten = Integer.parseInt(tastatur.readLine());
                  am.printDfsAnalyse(Startknoten,Endknoten);
                  break;

               case 'x':
               // PROGRAMM BEENDEN
                  /* Schleife wird unten verlassen */
                  break;

               default:
                  System.out.println("Bitte whlen Sie einen gltigen Menbefehl aus.");
            }
            } catch(NumberFormatException e) {
               System.out.println("Bitte geben Sie eine Zahl ein.");
            } catch(IllegalArgumentException e) {
               System.out.println("Unzulssiger Parameterwert: " + e);
            } catch(IndexOutOfBoundsException e) {
               System.out.println("Der angegebene Wert war nicht zulssig.");
            } catch(java.io.IOException e) {
               System.out.println("Fehler beim Einlesen von der Tastatur: " + e);
            }
         }
      } while (menubefehl != 'x');
      } catch(java.io.IOException e) {
         System.out.println("Fehler beim Einlesen von der Tastatur: " + e);
      }
      System.out.println("Auf Wiedersehen!");

   }


}
