
/**
 * Die Klasse EmailverzeichnisTestApp testet die Klasse Emailverzeichnis.
 *
 * @author Clemens Bruckmann
 *
 * @version 2005-03-16
 */
public class EmailverzeichnisTestApp {

   public static void main(String[] args) {
      Emailverzeichnis ev = new Emailverzeichnis();
      ev.eintragen("Johanna", "johanna_k@univie.ac.at");
      System.out.println("Das Verzeichnis enthlt derzeit " +
                         (ev.anzahlEintrge() == 1 ?
                          "1 Eintrag." :
                          (ev.anzahlEintrge() + " Eintrge.")));
      if (args.length > 0) {
         try {
            ev.readFromFile(new java.io.File(args[0]));
         } catch(java.io.IOException e) {
            System.out.println("Fehler beim Einlesen von der Datei " + args[0] + ":\n" +
                               e.getLocalizedMessage());
         } catch(ParsingException e) {
            System.out.println("Die Datei " + args[0] + " hat ein ungltiges Dateiformat:\n" +
                               e.getLocalizedMessage());
         }
      }
      System.out.println("Das Verzeichnis enthlt derzeit " +
                         (ev.anzahlEintrge() == 1 ?
                          "1 Eintrag." :
                          (ev.anzahlEintrge() + " Eintrge.")));
      try {
         java.io.BufferedReader br = new java.io.BufferedReader(new java.io.InputStreamReader(System.in));
         String name, email;
         do {   /* solange der Benutzer nicht "ende" eingegeben hat */
            System.out.print("Bitte geben Sie einen Namen ein (oder ende zum Beenden): ");
            name = br.readLine();
            if (!name.equals("ende")) {
               System.out.print("Bitte geben Sie die Emailadresse von " + name + " ein: ");
               email = br.readLine();
               ev.eintragen(name, email);
            }
         } while (!name.equals("ende"));
         /* wir schlieen die Reader nicht, da sie noch          */
         /* fr weitere Tastatureingaben bentigt werden knnten */
      } catch(java.io.IOException e) {
         System.out.println("Beim Einlesen von der Tastatur ist eine IOException aufgetreten:\n" +
                            e.getLocalizedMessage());
      }
      System.out.println("Das Verzeichnis enthlt derzeit " +
                         (ev.anzahlEintrge() == 1 ?
                          "1 Eintrag." :
                          (ev.anzahlEintrge() + " Eintrge.")));
      System.out.println("Johanna: " + ev.nachschlagen("Johanna"));
      System.out.println("Johann: " + ev.nachschlagen("Johann"));
      System.out.println("Beate: " + ev.nachschlagen("Beate"));
      System.out.println("Johanna, Beate und Hermann werden entfernt:");
      ev.entfernen("Johanna");
      ev.entfernen("Beate");
      ev.entfernen("Hermann");
      System.out.println("Das Verzeichnis enthlt derzeit " +
                         (ev.anzahlEintrge() == 1 ?
                          "1 Eintrag." :
                          (ev.anzahlEintrge() + " Eintrge.")));
      System.out.println("Johanna: " + ev.nachschlagen("Johanna"));
      System.out.println("Johann: " + ev.nachschlagen("Johann"));
      System.out.println("Beate: " + ev.nachschlagen("Beate"));
   }

}
