
/**
 * Die Klasse Emailverzeichnis verwaltet ein Directory
 * von Namen und zugehrigen e-mail-Adressen.
 *
 * @author Clemens Bruckmann
 *
 * @version 2005-03-16
 */
public class Emailverzeichnis {

   /**
    * Das Verzeichnis.
    */
   protected java.util.Map map;

   /**
    * Konstruktor.
    */
   public Emailverzeichnis() {
      map = new java.util.HashMap();   // oder TreeMap
   }

   /**
    * Fgt einen Eintrag ein.
    * Falls der Name bereits enthalten war, wird die alte e-mail-Adresse ersetzt.
    */
   public void eintragen(String name, String email) {
      map.put(name, email);
   }

   /**
    * Schlgt eine e-mail-Adresse nach.
    *
    * @return die e-mail-Adresse, oder null falls kein Eintrag vorhanden ist.
    */
   public String nachschlagen(String name) {
      return (String) map.get(name);
   }

   /**
    * Entfernt einen Eintrag.
    */
   public void entfernen(String name) {
      map.remove(name);
   }

   /**
    * Gibt die Anzahl der Eintrge an.
    */
   public int anzahlEintrge() {
      return map.size();
   }

   /**
    * Liest Eintrge aus einer Datei und fgt diese in das Verzeichnis ein.
    *
    * @throws java.io.IOException falls ein Fehler beim Einlesen der Datei
    *                             aufgetreten ist.
    * @throws ParsingException    falls eine oder mehrere Zeilen der Textdatei
    *                             ein ungltiges Format haben. Die gltigen
    *                             Zeilen werden alle eingelesen.
    */
   public void readFromFile(java.io.File f) throws java.io.IOException {
      int anzahlDerUngltigenZeilen = 0;
      java.io.FileInputStream   fis = null;
      java.io.InputStreamReader isr = null;
      java.io.BufferedReader    br  = null;
      try {
         fis = new java.io.FileInputStream(f);
         isr = new java.io.InputStreamReader(fis);
         br  = new java.io.BufferedReader(isr);
         for (String zeile = br.readLine();
              zeile != null; 
              zeile = br.readLine()) {
            zeile = zeile.trim();
            if (!(zeile.equals("") || zeile.charAt(0) == '#')) {     // Leer- oder Kommentarzeile
               int positionDesIstgleichzeichens = zeile.indexOf('=');
               if (positionDesIstgleichzeichens == -1) {
                  /* es gibt kein Istgleichzeichen => ungltige Zeile */
                  anzahlDerUngltigenZeilen = anzahlDerUngltigenZeilen + 1;
               } else {
                  /* Zeile mit gltigem Eintrag */
                  this.eintragen(zeile.substring(0, positionDesIstgleichzeichens),
                                 zeile.substring(positionDesIstgleichzeichens + 1));
               }
            }
         }
         if (anzahlDerUngltigenZeilen > 0) {
            throw new ParsingException(anzahlDerUngltigenZeilen);
         }
      /* wir haben hier KEINEN catch-Block;              */
      /* eine allfllige java.io.IOException soll        */
      /* (nach Ausfhrung des finally-Blocks) an das     */
      /* aufrufende Programmstck weitergegeben werden.  */
      } finally {
         try {
            if (br  != null) br.close();
         } catch(java.io.IOException e) {
            /* wir ignorieren diese Exception */
         }
         try {
            if (isr != null) isr.close();
         } catch(java.io.IOException e) {
            /* wir ignorieren diese Exception */
         }
         try {
            if (fis != null) fis.close();
         } catch(java.io.IOException e) {
            /* wir ignorieren diese Exception */
         }
      }
   }

}
