
/**
 * Die Klasse ArrayIterator stellt einen Iterator ber die
 * Elemente eines Feldes dar.
 *
 * @author Clemens Bruckmann
 *
 * @version 2005-04-06
 */
public class ArrayIterator implements java.util.Iterator {

   /**
    * Das Feld, dessen Elemente dieser Iterator
    * eines nach dem anderen liefern soll.
    */
   protected Object[] feld;

   /**
    * Der Index des nchsten von diesem Iterator zu
    * liefernden Feldelements.
    */
   protected int nextIndex = 0;

   /**
    * Konstruktor.
    *
    * @param f das Feld, dessen Elemente dieser Iterator
    *          eines nach dem anderen liefern soll.
    */
   public ArrayIterator(Object[] f) {
      feld = f;
   }

   /**
    * Liefert true falls der Iterator noch weitere Elemente bereithlt.
    */
   public boolean hasNext() {
      return nextIndex < feld.length;
   }

   /**
    * Liefert das nchste Element.
    *
    * @throws java.util.NoSuchElementException falls es keine weiteren
    *                                          Elemente gibt.
    */
   public Object next() throws java.util.NoSuchElementException {
      if (nextIndex < feld.length) {
         int oldIndex = nextIndex;
         nextIndex = nextIndex + 1;
         return feld[oldIndex];
         // oder krzer statt der letzten drei Anweisungen:
         // return feld[nextIndex++];
      } else {
         throw new java.util.NoSuchElementException();
      }
   }

   /**
    * Nicht untersttzt.
    *
    * Diese optionale Methode sollte das zuletzt vom Iterator gelieferte
    * Element aus der Datenstruktur entfernen.
    *
    * Die vorliegende Implementation wirft stets eine UnsupportedOperationException.
    *
    * @throws UnsupportedOperationException immer!
    */
   public void remove() {
      throw new UnsupportedOperationException();
   }

}
