
// Klasse AbstractGraph

   /**
    * Gibt diesen Graphen als XGMML-Dokument zurck.
    *
    * Die Methode toXgmml() gibt ein XGMML-Dokument als String zurck;
    * die Methode, die die Methode toXgmml() aufruft, kann dann
    * dieses Dokument z. B. in eine Datei speichern.
    */
   public String toXgmml() {
      StringBuilder xmlSb = new StringBuilder();
      final String newline = System.getProperty("line.separator");
      xmlSb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?>" + newline +
                   "<!DOCTYPE graph" + newline +
                   "          PUBLIC \"-//John Punin//DTD graph description//EN\"" + newline +
                   "          \"http://www.cs.rpi.edu/~puninj/XGMML/xgmml.dtd\">" + newline +
                   "<graph xmlns=\"http://www.cs.rpi.edu/XGMML\" " +
                   "directed=\"" + (this.directed() ? "1" : "0") +
                   "\" Vendor=\"AbstractGraph.java, " + System.getProperty("user.name") + "\">" + newline);
      for (int i = 0; i < this.getNumberOfVertices(); ++i) {
         xmlSb.append("<node id=\"" + i + "\"" +
                      ((this.getVertexLabel(i) != null) ? " label=\"" + this.getVertexLabel(i) + "\"" : "") +
                      "/>" + newline);
      }
      for (java.util.Iterator<Graph.Edge> it = this.edgeIterator(); it.hasNext(); ) {
         Graph.Edge edge = it.next();
         xmlSb.append("<edge source=\"" + edge.getFromVertex() +
                      "\" target=\"" + edge.getToVertex() +
                      "\" weight=\"" + edge.getWeight() + "\"/>" + newline);
      }
      xmlSb.append("</graph>" + newline);
      return xmlSb.toString();
   }

// Klasse AdjListGraph

   /**
    * Meldet, ob der Graph die angegebene Kante enthlt.
    *
    * @param fromVertex der Knoten, von welchem die Kante ausgehen soll
    * @param toVertex   der Knoten, zu welchem die Kante hinfhren soll
    *
    * @throws IndexOutOfBoundsException falls fromVertex oder toVertex auerhalb des zulssigen Bereichs liegt
    *                                   (0 .. getNumberOfVertices()-1).
    */
   public boolean containsEdge(int fromVertex, int toVertex) {
      if (toVertex < 0 || toVertex >= this.getNumberOfVertices()) {
         throw new IndexOutOfBoundsException("Unzulssiger Knotenindex: " + toVertex);
      }
      for (java.util.Iterator<Graph.Edge> it = e[fromVertex].iterator(); it.hasNext(); ) {
         Graph.Edge edge = it.next();
         if (edge.getToVertex() == toVertex) {
            return true;
         }
      }
      return false;
   }

   /**
    * Liefert das Kantengewicht einer Kante.
    * Existiert die angegebene Kante nicht, so wirft die Methode
    * eine IllegalStateException.
    *
    * @param fromVertex der Knoten, von welchem die Kante ausgeht
    * @param toVertex   der Knoten, zu welchem die Kante hinfhrt
    *
    * @throws IndexOutOfBoundsException falls fromVertex oder toVertex auerhalb des zulssigen Bereichs liegt
    *                                   (0 .. getNumberOfVertices()-1).
    * @throws IllegalStateException     falls die angegebene Kante nicht existiert.
    */
   public double getEdgeWeight(int fromVertex, int toVertex) {
      if (toVertex < 0 || toVertex >= this.getNumberOfVertices()) {
         throw new IndexOutOfBoundsException("Unzulssiger Knotenindex: " + toVertex);
      }
      for (java.util.Iterator<Graph.Edge> it = e[fromVertex].iterator(); it.hasNext(); ) {
         Graph.Edge edge = it.next();
         if (edge.getToVertex() == toVertex) {
            return edge.getWeight();
         }
      }
      throw new IllegalStateException("Kante existiert nicht");
   }

   /**
    * Entfernt die angegebene Kante aus dem Graphen.
    *
    * @param fromVertex der Knoten, von welchem die Kante ausgeht
    * @param toVertex   der Knoten, zu welchem die Kante hinfhrt
    *
    * @return true falls die Kante vorher enthalten war.
    *
    * @throws IndexOutOfBoundsException falls fromVertex oder toVertex auerhalb des zulssigen Bereichs liegt
    *                                   (0 .. getNumberOfVertices()-1).
    */
   public boolean removeEdge(int fromVertex, int toVertex) {
      if (toVertex < 0 || toVertex >= this.getNumberOfVertices()) {
         throw new IndexOutOfBoundsException("Unzulssiger Knotenindex: " + toVertex);
      }
      for (java.util.Iterator<Graph.Edge> it = e[fromVertex].iterator(); it.hasNext(); ) {
         Graph.Edge edge = it.next();
         if (edge.getToVertex() == toVertex) {
            it.remove();
            if (directed) {
               return true;
            } else {
               for (it = e[toVertex].iterator(); it.hasNext(); ) {
                  edge = it.next();
                  if(edge.getToVertex() == fromVertex) {
                     it.remove();
                     return true;
                  }
               }
               throw new IllegalStateException("korrespondierende Kante fehlt");
            }
         }
      }
      return false;
   }

// Klasse AdjMatrixGraph

   /**
    * Meldet, ob der Graph die angegebene Kante enthlt.
    *
    * @param fromVertex der Knoten, von welchem die Kante ausgehen soll
    * @param toVertex   der Knoten, zu welchem die Kante hinfhren soll
    *
    * @throws IndexOutOfBoundsException falls fromVertex oder toVertex auerhalb des zulssigen Bereichs liegt
    *                                   (0 .. getNumberOfVertices()-1).
    */
   public boolean containsEdge(int fromVertex, int toVertex) {
      return (e[fromVertex][toVertex] != NOEDGE);
   }

   /**
    * Liefert das Kantengewicht einer Kante.
    * Existiert die angegebene Kante nicht, so wirft die Methode
    * eine IllegalStateException.
    *
    * @param fromVertex der Knoten, von welchem die Kante ausgeht
    * @param toVertex   der Knoten, zu welchem die Kante hinfhrt
    *
    * @throws IndexOutOfBoundsException falls fromVertex oder toVertex auerhalb des zulssigen Bereichs liegt
    *                                   (0 .. getNumberOfVertices()-1).
    * @throws IllegalStateException     falls die angegebene Kante nicht existiert.
    */
   public double getEdgeWeight(int fromVertex, int toVertex) {
      if (e[fromVertex][toVertex] == NOEDGE) {
         throw new IllegalStateException("Kante existiert nicht");
      } else {
         return e[fromVertex][toVertex];
      }
   }

   /**
    * Entfernt die angegebene Kante aus dem Graphen.
    *
    * @param fromVertex der Knoten, von welchem die Kante ausgeht
    * @param toVertex   der Knoten, zu welchem die Kante hinfhrt
    *
    * @return true falls die Kante vorher enthalten war.
    *
    * @throws IndexOutOfBoundsException falls fromVertex oder toVertex auerhalb des zulssigen Bereichs liegt
    *                                   (0 .. getNumberOfVertices()-1).
    */
   public boolean removeEdge(int fromVertex, int toVertex) {
      if (e[fromVertex][toVertex] != NOEDGE) {
         e[fromVertex][toVertex] = NOEDGE;
         if (!directed) {
            e[toVertex][fromVertex] = NOEDGE;
         }
         return true;
      } else {
         return false;
      }      
   }
