
/**
 * Wird geworfen, um anzuzeigen, dass beim Einlesen aus einer Textdatei
 * eine oder mehrere Zeilen ein ungltiges Format hatten.
 *
 * @author Clemens Bruckmann
 *
 * @version 2005-03-16
 */
public class ParsingException extends IllegalArgumentException {

   /**
    * Die Anzahl der ungltigen Zeilen.
    */
   protected int anzahlDerUngltigenZeilen;

   /**
    * Konstruktor.
    *
    * @param anzahlDerUngltigenZeilen die Anzahl der ungltigen Zeilen.
    */
   public ParsingException(int anzahlDerUngltigenZeilen) {
      /* Aufruf des Konstruktors der Superklasse */
      super("Fehler beim Einlesen der Datei: " +
            anzahlDerUngltigenZeilen +
            " Zeile(n) hatte(n) ein ungltiges Format.");
      this.anzahlDerUngltigenZeilen = anzahlDerUngltigenZeilen;
   }

   /**
    * Liefert die Anzahl der ungltigen Zeilen.
    */
   public int getAnzahlDerUngltigenZeilen() {
      return anzahlDerUngltigenZeilen;
   }

}
