%{
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include "symbol_table.h"
	#include "tree.h"
	#include "code_gen.h"
%}

%start		Program

%token		NUMBER ID
%token		FUNC END GOTO IF RETURN AND NOT

@autosyn has_call

@attributes 	{ struct symbol_t *defined_labels; struct symbol_t *referenced_labels; char *function_name; int has_call; } Stats
@attributes 	{ struct symbol_t *defined_labels; struct symbol_t *referenced_labels; int has_call; } Funcdef
@attributes	{ struct symbol_t *defined_labels; } Labels
@attributes	{ struct symbol_t *referenced_labels; treenode *node; char *function_name; int has_call; } Stat
@attributes	{ char *function_name; } Label
@attributes	{ char *name; } ID NUMBER
@attributes	{ struct symbol_t *variables; int has_func_call; } Ids
@attributes	{ treenode *node; int has_call; } Expr Term Plusterm Malterm Andterm Array Lexpr
@attributes	{ treenode *node; } Call
@attributes	{ treenode *node; int terme; } Terme

@traversal @postorder t
@traversal @preorder u
@traversal @postorder v

%%

Program:	  Funcdef ';' Program
       		|
       		;

Funcdef:	  FUNC ID '{' Ids '}' Stats END
       		@{ @i @Funcdef.defined_labels@ = clone_table(@Stats.defined_labels@);
		   @i @Funcdef.referenced_labels@ = clone_table(@Stats.referenced_labels@);
		   @i @Stats.function_name@ = @ID.name@;
		   @i @Funcdef.has_call@ = @Stats.has_call@;
		   @i @Ids.has_func_call@ = @Stats.has_call@;
		
		   @t if(!contains_all(@Stats.defined_labels@, @Stats.referenced_labels@)) exit(3);
		   @t if(contains_duplicates(@Stats.defined_labels@)) exit(3);
		   @u function_header(@ID.name@,@Funcdef.has_call@); func_par_index=0; clear_register_assignments();
		   @v function_footer();
		@}
       		;

Ids:		  ID Ids
   		@{ @i @Ids.0.variables@ = table_add_symbol(clone_table(@Ids.1.variables@), @ID.name@);
		   @i @Ids.1.has_func_call@ = @Ids.0.has_func_call@;

		   @t if(check_symbol_defined(@Ids.1.variables@, @ID.name@)) exit(3);
		   @u function_parameter(@ID.name@, @Ids.has_func_call@);
		@}

   		|
		@{ @i @Ids.variables@ = new_table();
		
		   @u func_par_index=16;
		@}

   		;

Stats:		  Labels Stat ';' Stats
     		@{ @i @Stats.0.defined_labels@ = table_merge(@Labels.defined_labels@, @Stats.1.defined_labels@);
		   @i @Stats.0.referenced_labels@ = table_merge(@Stat.referenced_labels@, @Stats.1.referenced_labels@);
		   @i @Stat.function_name@ = @Stats.0.function_name@;
		   @i @Stats.1.function_name@ = @Stats.0.function_name@;
		   @i @Stats.0.has_call@ = @Stat.has_call@ || @Stats.1.has_call@;

		   @u print_labels(@Stats.0.function_name@, @Labels.defined_labels@); if(@Stat.node@!=(treenode *)NULL) { burm_label(@Stat.node@); burm_reduce(@Stat.node@, 1); }
		@}

     		|
		@{ @i @Stats.defined_labels@ = new_table();
		   @i @Stats.referenced_labels@ = new_table();
		   @i @Stats.has_call@ = 0;
		@}

		;

Labels:		  Labels ID ':'
		@{ @i @Labels.0.defined_labels@ = table_add_symbol(@Labels.1.defined_labels@, @ID.name@);
		@}

      		| 
		@{ @i @Labels.defined_labels@ = new_table();
		@}

		;

Stat:		  Lexpr '=' Expr
    		@{ @i @Stat.referenced_labels@ = new_table();
		   @i @Stat.node@ = new_node(OP_Assign, @Lexpr.node@, @Expr.node@);
		   @i @Stat.has_call@ = @Lexpr.has_call@ || @Expr.has_call@;
		@}

    		| GOTO ID
		@{ @i @Stat.referenced_labels@ = table_add_symbol(new_table(), @ID.name@);
		   @i @Stat.node@ = (treenode *)NULL;
		   @i @Stat.has_call@ = 0;

		   @u printf("\tbr %s\n",generate_label(@Stat.function_name@, @ID.name@));
		@}

		| IF Expr GOTO ID
		@{ @i @Stat.referenced_labels@ = table_add_symbol(new_table(), @ID.name@);
		   @i @Stat.node@ = new_named_node(OP_IF, @Expr.node@, (treenode *)NULL, generate_label(@Stat.function_name@, @ID.name@));
		@}

		| Call
    		@{ @i @Stat.referenced_labels@ = new_table();
		   @i @Stat.node@ = @Call.node@;
		   @i @Stat.has_call@ = 1;
		@}
		
		| RETURN Expr
    		@{ @i @Stat.referenced_labels@ = new_table();
                   @i @Stat.node@=new_node(OP_Return, @Expr.node@, (treenode *)NULL);
		@}
		
		;

Lexpr:		  ID
                @{ @i @Lexpr.node@ = new_named_leaf(OP_ID, @ID.name@);
		   @i @Lexpr.has_call@ = 0;
		@}
		
     		| Array
		@{ @i @Lexpr.node@ = @Array.node@;
		@}
		
		;

Expr:		  Term
    		@{ @i @Expr.node@ = @Term.node@;
		@}
		
		| NOT Term
		@{ @i @Expr.node@ = new_node(OP_Not, @Term.node@, (treenode *)NULL);
		@}

		| Term '-' Term
		@{ @i @Expr.node@ = new_node(OP_Difference, @Term.0.node@, @Term.1.node@);
		   @i @Expr.has_call@ = @Term.0.has_call@ || @Term.1.has_call@;
		@}

		| Term Plusterm
		@{ @i @Expr.node@ = new_node(OP_Addition, @Term.node@, @Plusterm.node@);
		   @i @Expr.has_call@ = @Term.has_call@ || @Plusterm.has_call@;
		@}

		| Term Malterm
		@{ @i @Expr.node@ = new_node(OP_Multiplication, @Term.node@, @Malterm.node@);
		   @i @Expr.has_call@ = @Term.has_call@ || @Malterm.has_call@;
		@}
		
		| Term Andterm
		@{ @i @Expr.node@ = new_node(OP_Conjunction, @Term.node@, @Andterm.node@);
		   @i @Expr.has_call@ = @Term.has_call@ || @Andterm.has_call@;
		@}
		
		| Term '<' Term
		@{ @i @Expr.node@ = new_node(OP_Smaller, @Term.0.node@, @Term.1.node@);
		   @i @Expr.has_call@ = @Term.0.has_call@ || @Term.1.has_call@;
		@}
		
		| Term '=' Term
		@{ @i @Expr.node@ = new_node(OP_Equal, @Term.0.node@, @Term.1.node@);
		   @i @Expr.has_call@ = @Term.0.has_call@ || @Term.1.has_call@;
		@}

		;

Plusterm:	  '+' Term Plusterm
		@{ @i @Plusterm.node@ = new_node(OP_Addition, @Term.node@, @Plusterm.1.node@);
		   @i @Plusterm.0.has_call@ = @Term.has_call@ || @Plusterm.1.has_call@;
		@}
		
		| '+' Term
		@{ @i @Plusterm.node@ = @Term.node@;
		@}

		;

Malterm:	  '*' Term Malterm
       		@{ @i @Malterm.0.node@ = new_node(OP_Multiplication, @Term.node@, @Malterm.1.node@);
		   @i @Malterm.0.has_call@ = @Term.has_call@ || @Malterm.1.has_call@;
		@}
		
       		| '*' Term
		@{ @i @Malterm.node@ = @Term.node@;
		@}
		
		;

Andterm:	  AND Term Andterm
       		@{ @i @Andterm.0.node@ = new_node(OP_Conjunction, @Term.node@, @Andterm.1.node@);
		   @i @Andterm.0.has_call@ = @Term.has_call@ || @Andterm.1.has_call@;
		@}
		
       		| AND Term
		@{ @i @Andterm.node@ = @Term.node@;
		@}
		
		;

Term:		  '(' Expr ')'
    		@{ @i @Term.node@ = @Expr.node@;
		@}
		
    		| ID
		@{ @i @Term.node@ = new_named_leaf(OP_ID, @ID.name@);
		   @i @Term.has_call@ = 0;
		@}

		| NUMBER
		@{ @i @Term.node@ = new_number_leaf(@NUMBER.name@);
		   @i @Term.has_call@ = 0;
		@}
		
		| Call
		@{ @i @Term.node@ = @Call.node@;
		   @i @Term.has_call@ = 1;
		@}
		
		| Array
		@{ @i @Term.node@ = @Array.node@;
		@}

		;

Array:		  Term '[' Expr ']'
     		@{ @i @Array.node@ = new_node(OP_Array, @Term.node@, @Expr.node@);
		   @i @Array.has_call@ = @Term.has_call@ || @Expr.has_call@;
		@}

     		;

Call:		  ID '{' Terme '}'
		@{ @i @Call.node@ = new_named_node(OP_Call, @Terme.node@, (treenode *)NULL, @ID.name@);
		   @t @Call.node@->value=@Terme.terme@;
		@}
		
    		;

Terme:		  Term Terme
     		@{ @i @Terme.0.node@ = new_node(OP_Terme, @Term.node@, @Terme.1.node@);
		   @i @Terme.0.terme@ = @Terme.1.terme@ + 1;
		@}
		
     		| 
		@{ @i @Terme.node@ = new_leaf(OP_Keine_Terme);
		   @i @Terme.terme@ = 0;
		@}
		
		;

%%

extern int yylex();

int yyerror(char *error_text) {
	exit(2);
}


