#include <stdio.h>
#include <stdlib.h>
#include "code_gen.h"

struct intstack *reg_stack;
int reg_used[32];
struct register_assignment *id_regs;
int func_par_index;
int has_func_call;

char *func_name;

int regstack_push(int reg) {
        struct intstack *new=(struct intstack *)malloc(sizeof(struct intstack));
        new->next=reg_stack;
        new->value=reg;
        reg_stack=new;

#ifdef DEBUG
        printf("reg_push: %i\n",reg);
#endif

        return reg;
}

int regstack_pop(void) {
        int reg;
        struct intstack *pop_element=reg_stack;

        if(reg_stack==(struct intstack *)NULL) {
                fprintf(stderr,"Internal error 1\n");
                exit(5);
        }

        reg_stack=pop_element->next;
        reg=pop_element->value;
        (void)free(pop_element);

        if(reg<0) {
                reg=-reg;
                printf("\tldq $%i, 0($sp)\n",reg);
                printf("\taddq $sp, 8, $sp\n"); 
	}

#ifdef DEBUG
	printf("reg_pop: %i\n",reg);
#endif
	
        return reg;
}

int newreg(void) {
        int a=has_func_call ? 9 : 1;

        while(1) {
                if(!reg_used[a]) {
                        reg_used[a]=1;
                        return a;
                }
		if(a==15) {
			a=1;
		}
		else if(a==8) {
                        a=22;
                }
                else if(a==25) {
/*                        a=9;
                }
                else if(a==14) { */
                        /* first step: search for least recently used register (bottom of stack)
                         * that has not been saved onto stack */
                        struct intstack *stackpointer=reg_stack;

                        while(stackpointer->next!=(struct intstack *)NULL && stackpointer->next->value>0) {
                                stackpointer=stackpointer->next;
                        }

                        /* second step: put value of this register onto stack */
                        printf("\tlda $sp, -8($sp)\n"); 
                        printf("\tstq $%i, 0($sp)\n",stackpointer->value); 

                        /* third step: set flag to 1 */
                        stackpointer->value=-stackpointer->value;

                        /* no free register found */
                        return -stackpointer->value; 
                }
                else {
                        a++;
                }
        }
}

int freereg(int reg) {
        struct register_assignment *first;
        struct register_assignment *previous;

        first=id_regs;
        previous=(struct register_assignment *)NULL;
        while(first!=(struct register_assignment *)NULL) {
                if(first->reg==reg) {
			return reg;
                }
                previous=first;
                first=first->next;
        }

        reg_used[reg]=0;

        return reg;
}

void program_header(void) {
	/* TODO */
}

void program_footer(void) {
	/* TODO */
}

void function_header(char *name, int func_call) {
	function_footer();
	func_name=strcpy((char *)malloc(strlen(name)+1),name);
	printf("\t.globl %s\n",name);
	printf("\t.ent %s\n\n",name);
	printf("%s:\n",name);
	
	if(func_call) {
		printf("\tldgp $29, 0($27)\n");
	}
	printf("$%s..ng:\n",name);

	if(func_call) {
		printf("\tlda $30,-64($30)\n");
		printf("\tstq $26,0($30)\n");
		int a;
		for(a=9;a<16;a++) {
			printf("\tstq $%i,%i($30)\n",a,(a-8)*8);
		}
	}
	has_func_call=func_call;
}

void function_footer(void) {
	if(func_name!=(char *)NULL) {
		printf("\t.end %s\n",func_name);
	}
	func_name=(char *)NULL;
}

void return_immediate_value(long number) {
	if(number>=0 && number<256) {
		printf("\tmov %li, $%i\n", number, 0);
	}
	else {
		printf("\tldiq $%i, %li\n", 0, number);
	}
	
	ret();
}

void load_immediate_value_int(long number, int reg_index) {
	if(number>=0 && number<256) {
		printf("\tmov %li, $%i\n", number, reg_index);
	}
	else {
		printf("\tldiq $%i, %li\n", reg_index, number);
	}
}

void load_immediate_value(char *text, int reg_index) {
	long number=get_number(text);

	if(number>=0 && number<256) {
		printf("\tmov %li, $%i\n", number, reg_index);
	}
	else {
		printf("\tldiq $%i, %li\n", reg_index, number);
	}
}

void clear_register_assignments() {
	id_regs=(struct register_assignment *)NULL;
}

void function_parameter(char *name, int has_call) {
	if(!has_call) {
		(void)new_identifier_reg(name,16+func_par_index);
		reg_used[16+func_par_index]=1;
	}
	else {
		int reg=newreg();
		printf("\tmov $%i, $%i\n",16+func_par_index,reg);
		(void)new_identifier_reg(name,reg);
		reg_used[reg]=1;
	}
	func_par_index++;
}

int get_register(char *name) {
        struct register_assignment *first;
        struct register_assignment *previous;
        int reg=-1;

        first=id_regs;
        previous=(struct register_assignment *)NULL;
        while(first!=(struct register_assignment *)NULL) {
                if(strcmp(first->name,name)==0) {
                        reg=first->reg;
                        break;
                }
                previous=first;
                first=first->next;
        }

        return reg;
}

int new_identifier_reg_noparam(char *name, int reg) {
        struct register_assignment *new;
        struct register_assignment *first;
        struct register_assignment *previous;

#ifdef DEBUG
	printf("id: %s, reg: %i\n",name,reg);
#endif

        first=id_regs;
        while(first!=(struct register_assignment *)NULL) {
                if(strcmp(first->name,name)==0) {
			printf("\tmov $%i, $%i\n",reg,first->reg);
			return reg;
                }
                first=first->next;
        }
        new=(struct register_assignment *)malloc(sizeof(struct register_assignment));
        new->reg=reg;
        new->name=(char *)malloc(strlen(name)+1);
	strcpy(new->name,name);
        new->next=(struct register_assignment *)NULL;

        first=id_regs;
        previous=(struct register_assignment *)NULL;
        while(first!=(struct register_assignment *)NULL) {
                previous=first;
                first=first->next;
        }
        if(previous==(struct register_assignment *)NULL) {
                id_regs=new;
        }
        else {
                previous->next=new;
        }

        return reg;
}

int new_identifier_reg(char *name, int reg) {
        struct register_assignment *new;
        struct register_assignment *first;
        struct register_assignment *previous;

#ifdef DEBUG
	printf("id: %s, reg: %i\n",name,reg);
#endif

        first=id_regs;
        while(first!=(struct register_assignment *)NULL) {
                if(strcmp(first->name,name)==0) {
                        fprintf(stderr,"Duplicate identifier\n");
                        exit(5);
                }
                first=first->next;
        }
        new=(struct register_assignment *)malloc(sizeof(struct register_assignment));
        new->reg=reg;
        new->name=(char *)malloc(strlen(name)+1);
	strcpy(new->name,name);
        new->next=(struct register_assignment *)NULL;

        first=id_regs;
        previous=(struct register_assignment *)NULL;
        while(first!=(struct register_assignment *)NULL) {
                previous=first;
                first=first->next;
        }
        if(previous==(struct register_assignment *)NULL) {
                id_regs=new;
        }
        else {
                previous->next=new;
        }

        return reg;
}

long get_number(char *name) {
        long number;
        char *eptr;

        return strtol(name, &eptr, 10);
}

void print_labels(char *function_name, struct symbol_t *tree) {
	struct symbol_t *element=tree;
	while(element!=(struct symbol_t *)NULL) {
		printf("\n%s_%s:\n",function_name,element->identifier);
		element=element->next;
	}
}

char *generate_label(char *function_name, char *label_name) {
	char *ret=(char *)malloc(strlen(function_name)+strlen(label_name)+2);
	ret[0]='\0';
	(void)strcat(ret,function_name);
	(void)strcat(ret,"_");
	(void)strcat(ret,label_name);
	return ret;
}

void do_call(char *function, int dest_reg, int param_count) {
	int a;
	
	for(a=15+param_count;a>15;a--) {
		printf("\tmov $%i, $%i\n",POP,a);
	}

	int to_be_saved=0;

	for(a=1;a<9;a++) {
		to_be_saved+=reg_used[a];
	}
	for(a=22;a<25;a++) {
		to_be_saved+=reg_used[a];
	}

	if(to_be_saved>0) {
		printf("\tlda $30,-%i($30)\n",to_be_saved*8);
	}
	
	int stackpos=0;
	for(a=1;a<9;a++) {
		if(reg_used[a]) {
			printf("\tstq $%i,%i($30)\n",a,8*stackpos++);
		}
	}
	for(a=22;a<25;a++) {
		if(reg_used[a]) {
			printf("\tstq $%i,%i($30)\n",a,8*stackpos++);
		}
	}
	
	printf("\tjsr %s\n",function);
	printf("\tldgp $29, 0($26)\n");
	
	for(a=25;a>21;a--) {
		if(reg_used[a]) {
			printf("\tldq $%i,%i($30)\n",a,8*--stackpos);
		}
	}
	for(a=8;a>0;a--) {
		if(reg_used[a]) {
			printf("\tldq $%i,%i($30)\n",a,8*--stackpos);
		}
	}
	if(to_be_saved>0) {
		printf("\tlda $30,%i($30)\n",to_be_saved*8);
	}

	if(dest_reg>0) {
		printf("\tmov $0, $%i\n",dest_reg);
	}
}

void ret(void) {
	if(has_func_call) {
		int a;
		for(a=15;a>8;a--) {
			printf("\tldq $%i,%i($30)\n",a,(a-8)*8);
		}
		printf("\tldq $26,0($30)\n");
		printf("\tlda $30,64($30)\n");
	}
	printf("\tret\n");
}
