#include <stdio.h>
#include <stdlib.h>
#include "code_gen.h"

struct intstack *reg_stack;
int reg_used[32];
struct register_assignment *id_regs;
int func_par_index;

char *func_name;

int regstack_push(int reg) {
        struct intstack *new=(struct intstack *)malloc(sizeof(struct intstack));
        new->next=reg_stack;
        new->value=reg;
        reg_stack=new;

#ifdef DEBUG
        printf("reg_push: %i\n",reg);
#endif

        return reg;
}

int regstack_pop(void) {
        int reg;
        struct intstack *pop_element=reg_stack;

        if(reg_stack==(struct intstack *)NULL) {
                fprintf(stderr,"Internal error 1\n");
                exit(5);
        }

        reg_stack=pop_element->next;
        reg=pop_element->value;
        (void)free(pop_element);

        if(reg<0) {
                reg=-reg;
                printf("\tldq $%i, 0($sp)\n",reg);
                printf("\taddq $sp, 8, $sp\n");
        }

#ifdef DEBUG
        printf("reg_pop: %i\n",reg);
#endif

        return reg;
}

int newreg(void) {
        int a=1;

        while(1) {
                if(!reg_used[a]) {
                        reg_used[a]=1;
                        return a;
                }
                if(a==8) {
                        a=22;
                }
                else if(a==25) {
         /*               a=9;
                }
                else if(a==14) { */
                        /* first step: search for least recently used register (bottom of stack)
                         * that has not been saved onto stack */
                        struct intstack *stackpointer=reg_stack; 

                        /* TODO: NULL ? */
                        while(stackpointer->next!=(struct intstack *)NULL && stackpointer->next->value>0) {
                                stackpointer=stackpointer->next;
                        }

                        /* second step: put value of this register onto stack */
                        printf("\tlda $sp, -8($sp)\n");
                        printf("\tstq $%i, 0($sp)\n",stackpointer->value);

                        /* third step: set flag to 1 */
                        stackpointer->value=-stackpointer->value;

                        /* no free register found */
                        return -stackpointer->value; 
                }
                else {
                        a++;
                }
        }
}

int freereg(int reg) {
        reg_used[reg]=0;

        return reg;
}

void program_header(void) {
	/* TODO */
}

void program_footer(void) {
	/* TODO */
}

void function_header(char *name) {
        function_footer();
        func_name=strcpy((char *)malloc(strlen(name)+1),name);
        printf("\t.globl %s\n",name);
        printf("\t.ent %s\n\n",name);
        printf("%s:\n",name);
}

void function_footer(void) {
        if(func_name!=(char *)NULL) {
                printf("\t.end %s\n",func_name);
        }
        func_name=(char *)NULL;
}

void return_immediate_value(long number) {
	if(number>=0 && number<256) {
		printf("\tmov %li, $%i\n", number, 0);
	}
	else {
		printf("\tldiq $%i, %li\n", 0, number);
	}
	
	printf("\tret\n");
}

void load_immediate_value_int(long number, int reg_index) {
	if(number>=0 && number<256) {
		printf("\tmov %li, $%i\n", number, reg_index);
	}
	else {
		printf("\tldiq $%i, %li\n", reg_index, number);
	}
}

void load_immediate_value(char *text, int reg_index) {
	long number=get_number(text);

	if(number>=0 && number<256) {
		printf("\tmov %li, $%i\n", number, reg_index);
	}
	else {
		printf("\tldiq $%i, %li\n", reg_index, number);
	}
}

void clear_register_assignments() {
	id_regs=(struct register_assignment *)NULL;
}

void function_parameter(char *name) {
	(void)new_identifier_reg(name,16+func_par_index);
	reg_used[16+func_par_index]=1;
	func_par_index++;
}

int get_register(char *name) {
        struct register_assignment *first;
        struct register_assignment *previous;
        int reg=-1;

        first=id_regs;
        previous=(struct register_assignment *)NULL;
        while(first!=(struct register_assignment *)NULL) {
                if(strcmp(first->name,name)==0) {
                        reg=first->reg;
                        break;
                }
                previous=first;
                first=first->next;
        }

        return reg;
}

int new_identifier_reg(char *name, int reg) {
        struct register_assignment *new;
        struct register_assignment *first;
        struct register_assignment *previous;

        first=id_regs;
        while(first!=(struct register_assignment *)NULL) {
                if(strcmp(first->name,name)==0) {
                        fprintf(stderr,"Duplicate identifier\n");
                        exit(5);
                }
                first=first->next;
        }
        new=(struct register_assignment *)malloc(sizeof(struct register_assignment));
        new->reg=reg;
        new->name=name;
        new->next=(struct register_assignment *)NULL;

        first=id_regs;
        previous=(struct register_assignment *)NULL;
        while(first!=(struct register_assignment *)NULL) {
                previous=first;
                first=first->next;
        }
        if(previous==(struct register_assignment *)NULL) {
                id_regs=new;
        }
        else {
                previous->next=new;
        }

        return reg;
}

long get_number(char *name) {
        long number;
        char *eptr;

        return strtol(name, &eptr, 10);
}


