#include <stdlib.h>

extern uac_sigbus();
extern unsigned char *asmb_callchecking(unsigned char* s, unsigned long l);
unsigned char *asmb(unsigned char *s, unsigned long n);

unsigned char *asmb_ref(unsigned char *s, unsigned long n)
{
	unsigned long i;
	for (i=0; i<n; i++) {
		unsigned char c=s[i];
		c += (c>='A' && c<='Z') ? 'a'-'A' : 0;
		s[i] = c;
	}
	return s;
}

int main() {
	char test[]="0123456789abcdefghijklm\nnopqr\n\nstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.""........";
	
	unsigned long a,b;
	unsigned char *test1=(unsigned char *)malloc(sizeof(unsigned char)*(strlen(test)+1));
	unsigned char *test2=(unsigned char *)malloc(sizeof(unsigned char)*(strlen(test)+1));
	unsigned char *bla1;
	unsigned char *bla2;
	int error=0;
	
	uac_sigbus();

	for(a=0;a<70;a++) {
		for(b=0;b<70-a;b++) {
			strcpy(test1,test);
			strcpy(test2,test);
			bla1=test1+a;
			bla2=test2+a;
			
			/* will terminate the program with exit code 9-15 or 30 if the value of a callee-saved
			 * register has been destroyed */
			unsigned char *bla3=asmb_callchecking(bla1,b);
			unsigned char *bla4=asmb_ref(bla2,b);
			if(bla1!=bla3 || bla2!=bla4) {
				printf("Ungueltiger Rueckgabewert\n");
			}
			if(strcmp(test1,test2)!=0) {
				printf("Testfall falsch, erwartet:\n%s\ntatsaechliches Ergebnis:\n%s\n\n",bla2,bla1);
				error++;
			}
		}
	}
	printf("%i Testfaelle falsch\n",error);
}


