	#include "parser.h"
	#include <stdio.h>

WHITESPACE	[ \r\n\t]
COMMENT		%.*
KEYWORD		func|end|goto|if|return|not|and
SPECIAL_CHAR	\;|\(|\)|\:|\=|\+|\*|\<|\[|\]|\{|\}|\-
IDENTIFIER	[[:alpha:]][[:alnum:]]*
NUMBER		[0-9]*
NEWLINE		\n

%%

{WHITESPACE}		/* ignore */

{COMMENT}		/* ignore */

{SPECIAL_CHAR}		return(yytext[0]);

func			return(FUNC);
end			return(END);
goto			return(GOTO);
if			return(IF);
return			return(RETURN);
not			return(NOT);
and			return(AND);

{NUMBER}		return(NUMBER);

{IDENTIFIER}		return(ID);

.			exit(1);

%%


