/* Uebersetzerbau SS 06
   Attributierte Grammatik
   Paul Staroch, 0425426
*/

#include <string.h>
#include <malloc.h>
#include <stdio.h>
#include "symbol_table.h"

struct tables *symbol_tables=(struct tables *)NULL;
extern int attributed_errors;

void remove_all_lists(void) {
	struct tables *element;
	struct tables *next_element;

#ifdef DEBUG
	(void)printf("Deleting all symbol tables...\n");
	(void)fflush(stdout);
#endif /* DEBUG */

	if((struct tables *)NULL==symbol_tables) {
		return;
	}
	element=symbol_tables;
	next_element=symbol_tables->next;
	while((struct tables *)NULL!=element) {
		next_element=element->next;
		free_table(element->table);
		(void)free(element->table);
		(void)free(element);
		element=next_element;
	}
}

int add_to_table_list(struct symbol_t *new_table) {
	struct tables *new_element;
	struct tables *element;

#ifdef DEBUG
	(void)printf("Adding new entry to list of symbol tables...\n");
	(void)fflush(stdout);
#endif /* DEBUG */
	
	if((new_element=(struct tables *)malloc(sizeof(struct tables)))==NULL) {
		return -1;
	}
	new_element->table=new_table;
	new_element->next=(struct tables *)NULL;

	element=symbol_tables;
	if((struct tables *)NULL==symbol_tables) {
		symbol_tables=new_element;
		return 0;
	}
	while((struct tables *)NULL!=element->next) {
		element=element->next;
	}
	element->next=new_element;
	return 0;
}
	
struct symbol_t *new_table(void) {
#ifdef DEBUG
	(void)printf("Initializing new symbol table...\n");
	(void)fflush(stdout);
#endif /* DEBUG */
	return (struct symbol_t *)NULL;
}

struct symbol_t *clone_table(struct symbol_t *table) {
	struct symbol_t *element;
	struct symbol_t *new_tablex;

#ifdef DEBUG
	(void)printf("Cloning symbol table...\n");
	(void)fflush(stdout);
#endif /* DEBUG */

	element=table;
	new_tablex=new_table();
	while((struct symbol_t *)NULL!=element) {
		/* check return value */
		new_tablex=table_add_symbol(new_tablex,element->identifier);
		element=element->next;
	}

#ifdef DEBUG
	(void)printf("Cloning completed...\n");
	(void)fflush(stdout);
#endif /* DEBUG */

	return new_tablex;
}

struct symbol_t *table_add_symbol(struct symbol_t *table, char *identifier) {
	struct symbol_t *element;
	struct symbol_t *new_element;

#ifdef DEBUG
	(void)printf("Adding identifier %s to symbol table...\n", identifier);
	(void)fflush(stdout);
#endif /* DEBUG */

/*	if(check_symbol_free(table,identifier)==0) {
		return table;
	}*/
	
	if((new_element=(struct symbol_t *)malloc(sizeof(struct symbol_t)))==NULL) {
		return (struct symbol_t *)NULL;
	}
	new_element->next=(struct symbol_t *)NULL;
	if((new_element->identifier=(char *)malloc(sizeof(char)*strlen(identifier)+1))==NULL) {
		(void)free(new_element);
		return (struct symbol_t *)NULL;
	}
	(void)strcpy(new_element->identifier,identifier);
	
	if((struct symbol_t *)NULL==table) {
		/* check return value */
		(void)add_to_table_list(new_element);
		return new_element;
	}
	element=table;

	while((struct symbol_t *)NULL!=element->next) {
		element=element->next;
	}

	element->next=new_element;
	
	return table;
}

struct symbol_t *table_remove_symbol(struct symbol_t *table, char *identifier) {
	struct symbol_t *element;
	struct symbol_t *previous_element;
	struct symbol_t *new_element;

#ifdef DEBUG
	(void)printf("Removing identifier %s from symbol table...\n",identifier);
	(void)fflush(stdout);
#endif /* DEBUG */
	
	if((struct symbol_t *)NULL==table) {
		return (struct symbol_t *)NULL;
	}

	previous_element=(struct symbol_t *)NULL;
	element=table;
	
	while((struct symbol_t *)NULL!=element->next) {
		if(strcmp(element->identifier,identifier)==0) {
			if((struct symbol_t *)NULL==previous_element) {
				new_element=element->next;
				(void)free(element->identifier);
				(void)free(element);
			}
			previous_element->next=element->next;
			(void)free(element->identifier);
			(void)free(element);
			return table;
		}
		previous_element=element;
		element=element->next;
	}

	return table;
	
	element=table;
}

int check_symbol_free(struct symbol_t *table, char *identifier) {
	if(table_lookup(table, identifier)!=(struct symbol_t *)NULL) {
		return 0;
	}
	return 1;
}

int check_symbol_defined(struct symbol_t *table, char *identifier) {
	if(table_lookup(table, identifier)==(struct symbol_t *)NULL) {
		return 0;
	}
	return 1;
}

struct symbol_t *table_lookup(struct symbol_t *table, char *identifier) {
	struct symbol_t *element;

#ifdef DEBUG
	(void)printf("Looking for identifier %s in symbol table...\n",identifier);
	(void)fflush(stdout);
#endif /* DEBUG */

	element=table;

	if((struct symbol_t *)NULL==table) {
		return (struct symbol_t *)NULL;
	}
	
	if(strcmp(element->identifier,identifier)==0) {
		return element;
	}
	
	while((struct symbol_t *)NULL!=element->next) {
		element=element->next;
		if(strcmp(element->identifier,identifier)==0) {
			return element;
		}
	}

	return (struct symbol_t *)NULL;
}

int table_size(struct symbol_t *table) {
	int a=0;
	struct symbol_t *element=table;

	while(element!=(struct symbol_t *)NULL) {
		a++;
		element=element->next;
	}

	return a;
}

struct symbol_t *table_merge(struct symbol_t *table, struct symbol_t *to_add) {
	struct symbol_t *element;
	struct symbol_t *new_table=clone_table(table);
	
#ifdef DEBUG
	(void)printf("Merging symbol tables...\n");
	(void)fflush(stdout);
	printf("size: %i\n",table_size(new_table));
	printf("size: %i\n",table_size(to_add));
#endif

	element=to_add;
	while(element!=(struct symbol_t *)NULL) {

#ifdef DEBUG
		printf("Merging identifier %s\n",element->identifier);
#endif

		new_table=table_add_symbol(new_table,element->identifier);
		element=element->next;
	}

	return new_table;
}

void free_table(struct symbol_t *table) {
	struct symbol_t *element;
	struct symbol_t *next_element;

#ifdef DEBUG
	(void)printf("Removing symbol table...\n");
	(void)fflush(stdout);
#endif /* DEBUG */

	if((struct symbol_t *)NULL==table) {
		return;
	}
	element=table;
	next_element=table->next;
	while((struct symbol_t *)NULL!=element) {
		next_element=element->next;
		(void)free(element->identifier);
		(void)free(element);
		element=next_element;
	}
}

int contains_all(struct symbol_t *table1, struct symbol_t *table2) {
	struct symbol_t *element=table2;

	while((struct symbol_t *)NULL!=element) {
		if(!check_symbol_defined(table1,element->identifier)) {
			return 0;
		}
		element=element->next;
	}

	return 1;
}

int contains_duplicates(struct symbol_t *table) {
#ifdef DEBUG
	printf("Looking for duplicates...\n");
#endif

	if(table==(struct symbol_t *)NULL) {
		return 0;
	}
	if(check_symbol_free(table->next, table->identifier)==0) {
		return 1;
	}
	return contains_duplicates(table->next);
}
