%{
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include "symbol_table.h"
%}

%start		Program

%token		NUMBER ID
%token		FUNC END GOTO IF RETURN AND NOT

@attributes 	{ struct symbol_t *defined_labels; struct symbol_t *referenced_labels; } Stats Funcdef
@attributes	{ struct symbol_t *defined_labels; } Labels
@attributes	{ struct symbol_t *referenced_labels; } Stat
@attributes	{ char *name; } ID
@attributes	{ struct symbol_t *variables; } Ids

@traversal @postorder t

%%

Program:	  Funcdef ';' Program
       		|
       		;

Funcdef:	  FUNC ID '{' Ids '}' Stats END
       		@{ @i @Funcdef.defined_labels@ = clone_table(@Stats.defined_labels@);
		   @i @Funcdef.referenced_labels@ = clone_table(@Stats.referenced_labels@);
		
		   @t if(!contains_all(@Stats.defined_labels@, @Stats.referenced_labels@)) exit(3);
		   @t if(contains_duplicates(@Stats.defined_labels@)) exit(3);
		@}
       		;

Ids:		  ID Ids
   		@{ @i @Ids.0.variables@ = table_add_symbol(clone_table(@Ids.1.variables@), @ID.name@);

		   @t if(check_symbol_defined(@Ids.1.variables@, @ID.name@)) exit(3);
		@}

   		|
		@{ @i @Ids.variables@ = new_table();
		@}

   		;

Stats:		  Labels Stat ';' Stats
     		@{ @i @Stats.0.defined_labels@ = table_merge(@Labels.defined_labels@, @Stats.1.defined_labels@);
		   @i @Stats.0.referenced_labels@ = table_merge(@Stat.referenced_labels@, @Stats.1.referenced_labels@);
		@}

     		|
		@{ @i @Stats.defined_labels@ = new_table();
		   @i @Stats.referenced_labels@ = new_table();
		@}

		;

Labels:		  Labels ID ':'
		@{ @i @Labels.0.defined_labels@ = table_add_symbol(@Labels.1.defined_labels@, @ID.name@); 
		@}

      		| 
		@{ @i @Labels.defined_labels@ = new_table();
		@}

		;

Stat:		  Lexpr '=' Expr
    		@{ @i @Stat.referenced_labels@ = new_table();
		@}

    		| GOTO ID
		@{ @i @Stat.referenced_labels@ = table_add_symbol(new_table(), @ID.name@);
		@}

		| IF Expr GOTO ID
		@{ @i @Stat.referenced_labels@ = table_add_symbol(new_table(), @ID.name@);
		@}

		| Call
    		@{ @i @Stat.referenced_labels@ = new_table();
		@}
		
		| RETURN Expr
    		@{ @i @Stat.referenced_labels@ = new_table();
		@}
		
		;

Lexpr:		  ID
     		| Array
		;

Expr:		  Term
		| NOT Term
		| Term '-' Term
		| Term Plusterm
		| Term Malterm
		| Term Andterm
		| Term '<' Term
		| Term '=' Term

Plusterm:	  '+' Term Plusterm
		| '+' Term
		;

Malterm:	  '*' Term Malterm
       		| '*' Term
		;

Andterm:	  AND Term Andterm
       		| AND Term
		;

Term:		  '(' Expr ')'
    		| ID
		| NUMBER
		| Call
		| Array
		;

Array:		  Term '[' Expr ']'
     		;

Call:		  ID '{' Terme '}'
    		;

Terme:		  Term Terme
     		|
		;

%%

extern int yylex();

int yyerror(char *error_text) {
	exit(2);
}

int main() {
	yyparse();
	return 0;
}

