	#include <stdio.h>

COMMENT		%.* 
WHITESPACE	[ \r\n\t]
KEYWORD		func|end|goto|if|return|not|and
SPECIAL_CHAR	\;|\(|\)|\:|\=|\+|\*|\<|\[|\]|\{|\}|\-
IDENTIFIER	[[:alpha:]][[:alnum:]]*
NUMBER		[0-9]*
NEWLINE		\n

%%

{WHITESPACE}		/* ignore */

{COMMENT}		/* ignore */

{SPECIAL_CHAR}		printf("%s\n",yytext);

{KEYWORD}		printf("%s\n",yytext);

{NUMBER}		printf("num %li\n", atol(yytext));

{IDENTIFIER}		printf("id %s\n",yytext);

.			exit(1);

%%

int main() {
	yylex();
	return 0;
}

