%{
	#include <stdio.h>
%}

%start		Program

%token		NUMBER ID
%token		FUNC END GOTO IF RETURN AND NOT

%%

Program:	  Funcdef ';' Program
       		|
       		;

Funcdef:	  FUNC ID '{' Ids '}' Stats END
       		;

Ids:		  ID Ids
		|
   		;

Stats:		  Labels Stat ';' Stats
     		| 
		;

Labels:		  Labels ID ':'
      		| 
		;

Stat:		  Lexpr '=' Expr
    		| GOTO ID
		| IF Expr GOTO ID
		| Call
		| RETURN Expr
		;

Lexpr:		  ID
     		| Array
		;

Expr:		  Term
		| NOT Term
		| Term '-' Term
		| Term Plusterm
		| Term Malterm
		| Term Andterm
		| Term '<' Term
		| Term '=' Term

Plusterm:	  '+' Term Plusterm
		| '+' Term
		;

Malterm:	  '*' Term Malterm
       		| '*' Term
		;

Andterm:	  AND Term Andterm
       		| AND Term
		;

Term:		  '(' Expr ')'
    		| ID
		| NUMBER
		| Call
		| Array
		;

Array:		  Term '[' Expr ']'
     		;

Call:		  ID '{' Terme '}'
    		;

Terme:		  Term Terme
     		|
		;

%%

extern int yylex();

int yyerror(char *error_text) {
	exit(2);
}

int main() {
	yyparse();
	return 0;
}

