#ifndef __CODE_GEN_H_
#define __CODE_GEN_H_

#define PUSH regstack_push(newreg())
#define POP freereg(regstack_pop())

#include "symbol_table.h"

struct intstack {
	struct intstack *next;
	int value;
};

struct register_assignment {
	struct register_assignment *next;
	char *name;
	int reg;
};

extern struct intstack *reg_stack;
extern int reg_used[32];
extern struct register_assignment *id_regs;
extern int func_par_index;

void ret(void);
int regstack_push(int reg);
int regstack_pop(void);
int freereg(int reg);
int newreg(void);
void program_header(void);
void program_footer(void);
void function_header(char *name, int has_call);
void function_footer(void);
void load_immediate_value(char *text, int reg_index);
void load_immediate_value_int(long value, int reg_index);
void return_immediate_value(long value);
void clear_register_assignments();
void function_parameter(char *name, int has_call);
int get_register(char *name);
int new_identifier_reg(char *name, int reg);
int new_identifier_reg_noparam(char *name, int reg);
long get_number(char *name);
void print_labels(char *function_name, struct symbol_t *tree);
char *generate_label(char *function_name, char *label_name);
void do_call(char *function, int dest_reg, int par_count);

#endif /* __CODE_GEN_H_ */
