/* Uebersetzerbau SS 06
   Attributierte Grammatik
   Paul Staroch, 0425426
*/

#ifndef SYMBOL_TABLE_H
#define SYMBOL_TABLE_H

#include <string.h>
#include <malloc.h>

struct symbol_t {
	char *identifier;
	struct symbol_t *next;
};

struct tables {
        struct symbol_t *table;
        struct tables *next;
};

int add_to_table_list(struct symbol_t *new_table);
void remove_all_lists(void);
struct symbol_t *clone_table(struct symbol_t *table);

struct symbol_t *new_table(void);
struct symbol_t *table_add_symbol(struct symbol_t *table, char *identifier);
struct symbol_t *table_remove_symbol(struct symbol_t *table, char *identifier);
struct symbol_t *table_lookup(struct symbol_t *table, char *identifier);
void free_table(struct symbol_t *table);
int checkSymbolFree(struct symbol_t *table, char *identifier);
int checkSymbolDefined(struct symbol_t *table, char *identifier);
struct symbol_t *table_merge(struct symbol_t *table, struct symbol_t *to_add);
int contains_all(struct symbol_t *table1, struct symbol_t *table2);
int contains_duplicates(struct symbol_t *table);

#endif /* SYMBOL_TABLE_H */

