/* Uebersetzerbau, SS 2006
 * Paul Staroch, 0425426
 * Gesamtbeispiel
 *
 * header file for tree.c
 */

#ifndef __TREE_H_
#define __TREE_H_

#ifndef CODE
typedef struct burm_state *STATEPTR_TYPE; 
#endif

enum {
	OP_Not=1,
	OP_Difference,
	OP_Addition,
	OP_Multiplication,
	OP_Conjunction,
	OP_Smaller,
	OP_Equal,
	OP_ID,
	OP_Number,
	OP_Array,
	OP_Return,
	OP_Zero,
	OP_One,
	OP_IF,
	OP_Assign
};

static char rule_names[100][100]={
	"",
        "OP_Not",
        "OP_Difference",
        "OP_Addition",
        "OP_Multiplication",
        "OP_Conjunction",
        "OP_Smaller",
        "OP_Equal",
        "OP_ID",
        "OP_Number",
        "OP_Array",
	"OP_Return",
	"OP_Zero",
	"OP_One",
	"OP_IF",
	"OP_Assign"
};
	  

/* struct for the tree build by ox for iburg */
typedef struct treenode {
	int op;
	struct treenode *kids[2];
	STATEPTR_TYPE label;
	char *name;
	long value;
	struct treenode *parent;
} treenode;

typedef treenode *treenodep;

/* macros for iburg being able to traverse the tree */
#define NODEPTR_TYPE    	treenodep
#define OP_LABEL(p)     	((p)->op)
#define LEFT_CHILD(p)   	((p)->kids[0])
#define RIGHT_CHILD(p)  	((p)->kids[1])
#define STATE_LABEL(p)  	((p)->label)
#define PANIC			printf

/* see tree.c for description about these procedures */
treenode *new_node(int op, treenode *left, treenode *right);
treenode *new_leaf(int op);
treenode *new_number_leaf(char *name);
treenode *new_named_leaf(int op, char *name);
treenode *new_named_leaf_values(int op, char *name);
treenode *new_named_node(int op, treenode *left, treenode *right, char *name);

void write_indent(int indent);
void write_tree(treenode *node, int indent);

#endif /* __TREE_H */

