	#include "parser.h"
	#include "tree.h"
	#include <stdio.h>

WHITESPACE	[ \r\n\t]
COMMENT		%.*
KEYWORD		func|end|goto|if|return|not|and
SPECIAL_CHAR	\;|\(|\)|\:|\=|\+|\*|\<|\[|\]|\{|\}|\-
IDENTIFIER	[[:alpha:]][[:alnum:]]*
NUMBER		[0-9]*
NEWLINE		\n

%%

{WHITESPACE}		/* ignore */

{COMMENT}		/* ignore */

";"			return(';');
"("			return('(');
")"			return(')');
":"			return(':');
"="			return('=');
"+"			return('+');
"*"			return('*');
"<"			return('<');
"["			return('[');
"]"			return(']');
"{"			return('{');
"}"			return('}');
"-"			return('-');

func			return(FUNC);
end			return(END);
goto			return(GOTO);
if			return(IF);
return			return(RETURN);
not			return(NOT);
and			return(AND);

{NUMBER}		return(NUMBER); @{ {
				char* p=(char*)malloc(yyleng+1);
				(void)strcpy(p,yytext);
				@NUMBER.name@=p;
			} @}
			
{IDENTIFIER}		return(ID); @{ {
				char* p=(char*)malloc(yyleng+1);
				(void)strcpy(p,yytext);
				@ID.name@=p;
			} @}

.			exit(1);

%%


