package dslab.reservation;

import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.SubtransactionsUnavailable;

import dslab.reservation.gen.ReservationFailed;
import dslab.reservation.gen.SeminarReservationSystem;

public abstract class TxCommand implements Command {
	private org.omg.CosTransactions.Current ts_current = null;

	protected org.omg.CORBA.ORB orb;

	public TxCommand(org.omg.CORBA.ORB orb) {
		this.orb = orb;

		try {
			ts_current = org.omg.CosTransactions.CurrentHelper.narrow(orb
					.resolve_initial_references("TransactionCurrent"));
		} catch (InvalidName e) {
			e.printStackTrace();
		}
	}

	public final void savepoint() {
		try {
			ts_current.begin();
		} catch (SubtransactionsUnavailable e) {
			e.printStackTrace();
		}
	}

	public final void commit() {
		try {
			ts_current.commit(true);
		} catch (NoTransaction e) {
			e.printStackTrace();
		} catch (HeuristicHazard e) {
			e.printStackTrace();
		} catch (HeuristicMixed e) {
			e.printStackTrace();
		}
	}

	public final void rollback() {
		try {
			ts_current.rollback();
		} catch (NoTransaction e) {
			e.printStackTrace();
		}
	}

	public final void processCommand(SeminarReservationSystem server,
			String[] args) throws InvalidArgumentCountException,
			ReservationFailed {
		processCommand(args);
	}

	public abstract void processCommand(String[] args)
			throws InvalidArgumentCountException, ReservationFailed;
}
