package dslab.reservation;

import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class SeminarReservationSystemServer {
	public static org.omg.CORBA.ORB orb;

	public static void main(String[] args) {
		if (args.length != 1) {
			System.err.println("Invalid number of arguments!");
			System.exit(1);
		}

		try {
			orb = org.omg.CORBA.ORB.init(args, null);

			org.omg.PortableServer.POA poa = org.omg.PortableServer.POAHelper
					.narrow(orb.resolve_initial_references("RootPOA"));

			poa.the_POAManager().activate();

			org.omg.CORBA.Object o = poa
					.servant_to_reference(new SeminarReservationSystem());

			((org.omg.CORBA_2_3.ORB) orb).register_value_factory(
					"IDL:dslab/reservation/gen/Customer:1.0",
					new CustomerFactory());

			NamingContextExt nc = NamingContextExtHelper.narrow(orb
					.resolve_initial_references("NameService"));
			nc
					.rebind(new NameComponent[] { new NameComponent(args[0],
							"server") }, o);

			orb.run();
		} catch (org.omg.CORBA.UserException e) {
			e.printStackTrace();
			System.err.println("Internal CORBA error!");
			System.exit(3);
		}
	}
}
