package at.ac.tuwien.dslab.rmi.server;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;

import at.ac.tuwien.dslab.rmi.common.impl.FileManException;
import at.ac.tuwien.dslab.rmi.common.interfaces.IFileManServer;
import at.ac.tuwien.dslab.rmi.common.interfaces.IFileManager;
import at.ac.tuwien.dslab.rmi.common.interfaces.IPropertyKeys;

/**
 * The <code>FileManServerImpl</code> is the implementation of the
 * <code>IFileManServer</code> interface.
 * 
 * @author Paul Staroch
 */
public class FileManServerImpl implements IFileManServer {
	/**
	 * instance of fileMan that will be exported via RMI
	 */
	private FileManagerImpl fileMan;
	
	/**
	 * Constructor
	 * @param Instance of <code>java.util.Properties</code> holding general
	 * information required to launch the server.
	 */
	public FileManServerImpl(Properties properties) {
		Global.setUserFile(properties.getProperty(IPropertyKeys.USER_FILE));
		Global.setDocumentRoot(properties.getProperty
				(IPropertyKeys.DOCUMENT_ROOT));
		Global.setRmiHostname(properties.getProperty
				(IPropertyKeys.RMI_HOSTNAME));
		Global.setRmiObject(properties.getProperty(IPropertyKeys.RMI_OBJECT));
		Global.setRmiPort(Integer.parseInt(properties.getProperty
				(IPropertyKeys.RMI_PORT)));
	}
	
	/**
	 * Starts the RMI server.
	 * @throws FileManException if an error occurs. 
	 */
	public void start() throws FileManException {
		fileMan=new FileManagerImpl();
		try {
	        IFileManager stub=
	        	(IFileManager)UnicastRemoteObject.exportObject(fileMan, 0);
	        Registry registry=LocateRegistry.getRegistry
	        	(Global.getRmiHostname(), Global.getRmiPort());
	        registry.rebind(Global.getRmiObject(), stub);
		}
		catch(Exception e) {
			throw new FileManException("Can't launch server.",e);
		}
	}

	/**
	 * Stops the RMI server.
	 * @throws FileManException if an error occurs.
	 */
	public void stop() throws FileManException {
		try {
//			LocateRegistry.getRegistry().unbind(Global.getRmiObject());
	        UnicastRemoteObject.unexportObject(fileMan, true);
		}
		catch(Exception e) {
			throw new FileManException("Can't stop server.",e);
		}
	}
	
	/**
	 * The server's main method.
	 * @param args command line arguments
	 */
	public static void main(String[] args) {
		if(args.length==1) {
			try {
				Properties properties=new Properties();
				FileInputStream stream=null;
				try {
					stream = new FileInputStream(args[0]);
				}
				catch (FileNotFoundException e) {
					return;
				}
				try {
					properties.load(stream);
					stream.close();
				}
				catch (IOException e) {
					return;
				}
				
				(new FileManServerImpl(properties)).start();
			}
			catch (FileManException e) {
				e.printStackTrace();
			}
		}
		else {
			System.err.println("Invalid number of command line arguments.");
		}
	}
}
