/*
 * Distributed Systems
 * Winter Term 2006/07
 * Lab 3
 * Paul Staroch, 0425426
 */

package at.ac.tuwien.dslab.rmi.client;

import at.ac.tuwien.dslab.rmi.common.interfaces.IFileManClient;
import at.ac.tuwien.dslab.rmi.common.interfaces.IFileManager;
import at.ac.tuwien.dslab.rmi.common.impl.FileManException;
import at.ac.tuwien.dslab.rmi.common.impl.InvalidCommandException;

import at.ac.tuwien.dslab.rmi.client.command.*;

import java.util.HashMap;

/**
 * FileManClientImpl is the main class of the File Manager client; it
 * parses the user input and calls <code>execute</code> in the
 * appropriate subclass of <code>Command</code>.
 *
 * @author Paul Staroch
 * @version 1.0
 */
public class FileManClientImpl implements IFileManClient {
	/**
	 * HashMap for the relationship between command names and objects
	 * that perform the command
	 */
	private HashMap<String, Command> commands;

	/**
	 * Default constructor
	 */
	public FileManClientImpl() {
		commands=new HashMap<String, Command>();
		
		commands.put("create-repo", new CreateRepositoryCommand());
		commands.put("del-repo", new DeleteRepositoryCommand());
		commands.put("checkout", new CheckoutCommand());
		commands.put("import", new ImportDocumentCommand());
		commands.put("commit", new CommitDocumentCommand());
		commands.put("update", new UpdateDocumentCommand());
		commands.put("del", new DeleteDocumentCommand());
	}
	
	/**
	 * main method
	 *
	 * @param args command line arguments
	 */
	public static void main(String[] args) {
		if(args.length==0) {
			System.err.println("No command specified.");
		}
		else {
			String[] commandArgs=new String[args.length-1];
			System.arraycopy(args, 1, commandArgs, 0,
					commandArgs.length);

			FileManClientImpl fileMan=new FileManClientImpl();
			try {
				System.out.println
					(fileMan.processCommand(args[0], 
								commandArgs));
			}
			catch(Exception e) {
				e.printStackTrace();
//				System.err.println(e.getMessage());
			}
		}
	}

	/**
	 * processes a command
	 *
	 * @param cmd name of the command
	 * @param args arguments for this command
	 * @throws InvalidCommandException if the command <code>cmd</code> is
	 * 	unknown or the arguments are incorrect
	 * @throws FileManException if any other error occurs
	 */
	public String processCommand(String cmd, String... args)
			throws InvalidCommandException, FileManException {
		if(!commands.containsKey(cmd)) {
			throw new InvalidCommandException("Unknown command: "+cmd);
		}

		/* let's do the work! */
		return commands.get(cmd).execute(args);
	}
}

