/*
 * Distributed Systems
 * Winter Term 2006/07
 * Lab 3
 * Paul Staroch, 0425426
 */

package at.ac.tuwien.dslab.rmi.client.command;

import at.ac.tuwien.dslab.rmi.client.command.Command;
import at.ac.tuwien.dslab.rmi.common.interfaces.IDocument;
import at.ac.tuwien.dslab.rmi.common.interfaces.IUser;
import at.ac.tuwien.dslab.rmi.common.impl.UserImpl;
import at.ac.tuwien.dslab.rmi.client.FileManClientConfig;
import at.ac.tuwien.dslab.rmi.common.impl.FileManException;
import at.ac.tuwien.dslab.rmi.common.interfaces.IFileManager;

import java.io.FileOutputStream;
import java.io.File;
import java.io.IOException;

import java.rmi.RemoteException;

/**
 * CheckoutCommand represents the command "checkout"
 */ 
public class CheckoutCommand extends Command {
	/**
	 * Constructor - sets minimal and maximal argument number
	 */
	public CheckoutCommand() {
		super();
		minArgumentNumber=5;
		maxArgumentNumber=5;
	}

	/**
	 * performs the command
	 *
	 * @param args arguments to the command
	 * @return message for the user (about success or failure)
	 * @throws FileManException if an error occurs
	 */
	public String executeNoCheckNumber(String... args)
			throws FileManException {
		/* initialize connection to server */
		IFileManager fileMan;
		try {
			fileMan=getFileManager(args[2]);
		}
		catch(FileManException fme) {
			return fme.getMessage();
		}

		IUser user=new UserImpl(args[0],args[1]);
				
		/* check if local directory exists */
		File workingDir=new File(args[4]);
		if(!workingDir.exists()) {
			workingDir.mkdirs();
		}
		else if(!workingDir.isDirectory()) {
			return "Specified path for working directory is not a directory.";
		}

		/* check out all files */
		IDocument[] documents;
		try {
			documents=fileMan.checkout(args[3],user);
		}
		catch(RemoteException re) {
			return "Communication error";
		}

		/* store configuration */
		FileManClientConfig config=new FileManClientConfig(args[4], false);
	
		config.setUsername(user.getName());
		config.setPassword(user.getPassword());
		config.setHost(args[2]);
		config.setRepository(args[3]);
		
		for (IDocument document : documents) {
			String filename=args[4]+File.separator+document.getName();
	
			/* write file in local working directory */		
			try {
				FileOutputStream output=new FileOutputStream(filename);
				output.write(document.getContent());
				output.flush();
				output.close();
			}
			catch (Exception e) {
				return "Error while writing file "+filename+".";
			}

			/* add file to configuration */
			config.addFile(document.getName(), document.getVersion());
		}

		try {
			config.writeConfig();
		}
		catch (IOException ioe) {
			return "Error while writing repository configuration file.";
		}

		return "Repository successfully checked out.";
	}
}

