package dslab.reservation;

import java.util.HashMap;

import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

import dslab.reservation.gen.ReservationFailed;
import dslab.reservation.gen.SeminarReservationSystemHelper;

public class Client {
	private HashMap<String, Command> commands = new HashMap<String, Command>();

	private void init() {
		commands.put("create", new CreateCommand());
		commands.put("book", new BookCommand());
		commands.put("cancelBooking", new CancelBookingCommand());
	}

	public static void main(String[] args) {
		Client client = new Client();
		client.run(args);
	}

	private void run(String[] args) {
		init();

		try {
			dslab.reservation.gen.SeminarReservationSystem server;

			if (args.length < 2) {
				throw new InvalidArgumentCountException();
			}

			org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, null);

			NamingContextExt nc = NamingContextExtHelper.narrow(orb
					.resolve_initial_references("NameService"));

			nc.to_name(args[0]);

			org.omg.CORBA.Object o = nc
					.resolve(new NameComponent[] { new NameComponent(args[0],
							"server") });

			server = SeminarReservationSystemHelper.narrow(o);

			if (!commands.containsKey(args[1])) {
				System.err.println("Unknown command: " + args[1]);
				System.exit(1);
			}

			String[] commandArgs = new String[args.length - 2];
			System.arraycopy(args, 2, commandArgs, 0, commandArgs.length);

			commands.get(args[1]).processCommand(server, commandArgs);
		} catch (ReservationFailed e) {
			System.err.println("Reservation failed.");
			System.exit(1);
		} catch (org.omg.CORBA.UserException e) {
			e.printStackTrace();
			System.exit(1);
		} catch (org.omg.CORBA.SystemException e) {
			e.printStackTrace();
			System.exit(1);
		} catch (InvalidArgumentCountException e) {
			System.err.println("Invalid number of arguments.");
			System.exit(1);
		} catch (NumberFormatException e) {
			System.err.println(e.getMessage());
			System.exit(1);
		}
	}
}
