package dslab.reservation;

import java.util.HashMap;

import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions.Vote;

import dslab.reservation.gen.Customer;
import dslab.reservation.gen.ReservationFailed;
import dslab.reservation.gen.TxSeminarPOA;

public class TxSeminarImpl extends TxSeminarPOA {
	private String lecturer;

	private int places;

	private int openPlaces;

	private String seminarID;

	private String seminarName;

	private HashMap<String, Integer> customerPlaces = new HashMap<String, Integer>();

	private ORB orb;

	private String changedKey;

	private int changedPlaces;

	private int changedCustomerPlaces;

	public TxSeminarImpl(ORB orb, String seminarID, String name,
			String lecturer, int places) {
		this.orb = orb;
		this.seminarID = seminarID;
		this.seminarName = name;
		this.lecturer = lecturer;
		this.places = places;
		this.openPlaces = places;
	}

	public void book(Customer customer, int numberPlaces)
			throws ReservationFailed {
		Control control;
		try {
			control = org.omg.CosTransactions.CurrentHelper.narrow(
					orb.resolve_initial_references("TransactionCurrent"))
					.get_control();
		} catch (InvalidName e1) {
			throw new ReservationFailed();
		}

		if (control != null) {
			try {
				control.get_coordinator().register_resource(_this());
			} catch (Inactive e) {
				throw new ReservationFailed(e.getMessage());
			} catch (Unavailable e) {
				throw new ReservationFailed(e.getMessage());
			}
		}

		if (openPlaces < numberPlaces) {
			throw new ReservationFailed("Not enough open places.");
		}

		changedPlaces = openPlaces - numberPlaces;
		changedKey = customer.firstName + "::" + customer.lastName;
		changedCustomerPlaces = customerPlaces.containsKey(changedKey) ? customerPlaces
				.get(changedKey)
				+ numberPlaces
				: numberPlaces;
		if (control == null) {
			commit();
		}
	}

	public void cancelBooking(Customer customer, int numberPlaces)
			throws ReservationFailed {
		Control control;
		try {
			control = org.omg.CosTransactions.CurrentHelper.narrow(
					orb.resolve_initial_references("TransactionCurrent"))
					.get_control();
		} catch (InvalidName e1) {
			throw new ReservationFailed();
		}

		if (control != null) {
			try {
				control.get_coordinator().register_resource(_this());
			} catch (Inactive e) {
				throw new ReservationFailed(e.getMessage());
			} catch (Unavailable e) {
				throw new ReservationFailed(e.getMessage());
			}
		}

		changedKey = customer.firstName + "::" + customer.lastName;
		if (!customerPlaces.containsKey(changedKey)
				|| customerPlaces.get(changedKey).intValue() < numberPlaces) {
			throw new ReservationFailed("Not enough booked places.");
		}

		changedPlaces = openPlaces + numberPlaces;
		changedCustomerPlaces = customerPlaces.get(changedKey) - numberPlaces;
		if (control == null) {
			commit();
		}
	}

	public int openPlaces() {
		return openPlaces;
	}

	public int places() {
		return places;
	}

	public String lecturer() {
		return lecturer;
	}

	public String seminarID() {
		return seminarID;
	}

	public String seminarName() {
		return seminarName;
	}

	public void seminarName(String seminarName) {
		this.seminarName = seminarName;
	}

	public void commit() {
		customerPlaces.put(changedKey, changedCustomerPlaces);
		openPlaces = changedPlaces;
	}

	public void commit_one_phase() {
		if (prepare() == Vote.VoteCommit) {
			commit();
		}
	}

	public void forget() {
		/* do nothing */
	}

	public Vote prepare() {
		return Vote.VoteCommit;
	}

	public void rollback() {
		/* do nothing */
	}
}
