package dslab.reservation;

import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

import dslab.reservation.gen.BaseSeminar;
import dslab.reservation.gen.Customer;
import dslab.reservation.gen.ReservationFailed;
import dslab.reservation.gen.SeminarReservationSystemHelper;

public class CancellistCommand extends TxCommand {
	public CancellistCommand(org.omg.CORBA.ORB orb) {
		super(orb);
	}

	public void processCommand(String[] args)
			throws InvalidArgumentCountException, ReservationFailed {
		if (args.length % 5 != 0) {
			throw new InvalidArgumentCountException();
		}

		/* start transaction */
		savepoint();

		/* do the work */
		try {
			NamingContextExt nc = NamingContextExtHelper.narrow(orb
					.resolve_initial_references("NameService"));

			for (int a = 0; a < args.length; a += 5) {
				dslab.reservation.gen.SeminarReservationSystem server;

				org.omg.CORBA.Object o = nc
						.resolve(new NameComponent[] { new NameComponent(
								args[a], "server") });

				server = SeminarReservationSystemHelper.narrow(o);

				boolean booked = false;
				for (BaseSeminar seminar : server.listSeminars()) {
					if (seminar.seminarID().equals(args[a + 1])) {
						Customer customer = new CustomerImpl(args[a + 2],
								args[a + 3]);
						int places = Integer.parseInt(args[a + 4]);

						server.cancelBooking(seminar, customer, places);
						booked = true;
						break;
					}
				}
				if (!booked) {
					throw new ReservationFailed();
				}
			}
		} catch (Exception e) {
			rollback();
			throw new ReservationFailed();
		}

		/* commit transaction */
		commit();
	}

}
