/*
 * Distributed Systems
 * Winter Term 2006/07
 * Lab 3
 * Paul Staroch, 0425426
 */

package at.ac.tuwien.dslab.rmi.client.command;

import at.ac.tuwien.dslab.rmi.client.command.Command;
import at.ac.tuwien.dslab.rmi.common.interfaces.IFileManager;
import at.ac.tuwien.dslab.rmi.common.impl.DocumentImpl;
import at.ac.tuwien.dslab.rmi.common.impl.UserImpl;
import at.ac.tuwien.dslab.rmi.client.FileManClientConfig;
import at.ac.tuwien.dslab.rmi.common.impl.FileManException;
import at.ac.tuwien.dslab.rmi.common.impl.InvalidCommandException;
import at.ac.tuwien.dslab.rmi.client.FileManConfigException;

import java.io.FileInputStream;
import java.io.File;
import java.io.IOException;

import java.rmi.RemoteException;

/**
 * ImportDocumentCommand represents the command "import"
 */
public class ImportDocumentCommand extends Command {
	/**
	 * Constructor - sets minimum and maximum argument number
	 */
	public ImportDocumentCommand() {
		super();
		minArgumentNumber=1;
		maxArgumentNumber=1;
	}

	/**
	 * performs the command
	 *
	 * @param args arguments to the command
	 * @return message for the user (about success or failure)
         * @throws InvalidCommandException if the command fails due to wrong
	 *	arguments
	 * @throws FileManException if an error occurs
	 */
	public String executeNoCheckNumber(String... args)
			throws FileManException {

		/* read configuration */
		FileManClientConfig config;
		try {
			config=new FileManClientConfig(".");
		}
		catch (FileManConfigException fmce) {
			throw new InvalidCommandException("Cannot read "+
					"repository configuration file.",fmce);
		}

		if(!config.configFileExists()) {
			throw new InvalidCommandException
				("No repository config file found.");
		}
		
		IFileManager fileMan;
		fileMan=getFileManager(config.getHost());

		UserImpl user=new UserImpl();
		user.setName(config.getUsername());
		user.setPasswordHashed(config.getPassword());

		if(args[0].indexOf(File.separator)>-1) {
			throw new InvalidCommandException
				("The file you want to import is not located "+
				 "in the local working directory.");
		}
		
		File file=new File(args[0]);
		if(!file.exists()) {
			throw new InvalidCommandException
				("The file you want to import does not "+
				 "exist.");
		}
		else if(!file.isFile()) {
			throw new InvalidCommandException
				("The file you want to import is not a "+
				 "normal file.");
		}

		/* read file */
		byte[] data=new byte[(int)file.length()];
		try {
			FileInputStream inputStream=new FileInputStream(file);
			inputStream.read(data);
			inputStream.close();
		}
		catch(IOException ioe) {
			throw new FileManException
				("Can't read from specified file.", ioe);
		}
		
		/* perform the import into the repository on the server */
		DocumentImpl document=new DocumentImpl(args[0],1,data);
		
		try {
			fileMan.importDocument(config.getRepository(),user,
					document);
		}
		catch (RemoteException re) {
			throw new FileManException
				("Communication error", re);
		}

		/* update local configuration */
		try {
			config.addFile(args[0],1);
			config.writeConfig();
		}
		catch(IOException ioe) {
			throw new FileManException("Error while updating "+
					"repository config file.", ioe);
		}
		return "File successfully imported.";
	}
}

