package dslab.reservation;

import java.util.Collection;
import java.util.LinkedHashMap;

import dslab.reservation.gen.BaseSeminar;
import dslab.reservation.gen.Customer;
import dslab.reservation.gen.ReservationFailed;
import dslab.reservation.gen.SeminarReservationSystemPOA;

public class SeminarReservationSystem extends SeminarReservationSystemPOA {
	LinkedHashMap<String, SeminarImpl> seminars = new LinkedHashMap<String, SeminarImpl>();

	public void book(BaseSeminar seminar, Customer customer, int numberPlaces)
			throws ReservationFailed {
		seminars.get(seminar.seminarID()).book(customer, numberPlaces);
	}

	public void cancelBooking(BaseSeminar seminar, Customer customer,
			int numberPlaces) throws ReservationFailed {
		seminars.get(seminar.seminarID()).cancelBooking(customer, numberPlaces);
	}

	public BaseSeminar create(String seminarID, String name, String lecturer,
			int places) {
		SeminarImpl seminar = new SeminarImpl(seminarID, name, lecturer, places);
		seminars.put(seminarID, seminar);
		return seminar._this(SeminarReservationSystemServer.orb);
	}

	public BaseSeminar[] listSeminars() {
		Collection<SeminarImpl> seminars = this.seminars.values();

		BaseSeminar[] ret = new BaseSeminar[seminars.size()];
		int j = 0;
		for (SeminarImpl seminar : seminars) {
			ret[j++] = seminar._this(SeminarReservationSystemServer.orb);
		}

		return ret;
	}

	public void rebook(BaseSeminar fromSeminar, BaseSeminar toSeminar,
			Customer customer, int numberPlaces) throws ReservationFailed {
		if (!fromSeminar.seminarName().equals(toSeminar.seminarName())) {
			throw new ReservationFailed("Seminar names are not equal.");
		}

		seminars.get(toSeminar.seminarID()).book(customer, numberPlaces);
		seminars.get(fromSeminar.seminarID()).cancelBooking(customer,
				numberPlaces);
	}
}
