package at.ac.tuwien.dslab.rmi.server;

/**
 * Global defines some global variables used in the server
 * 
 * @author Paul Staroch
 */
public class Global {
	/**
	 * name of the file where to read the usernames and passwords from; the
	 * users named in this file are allowed to create repositories; the set
	 * of the users that are allowed to access repositories is always a subset
	 * of the users named in this file
	 */
	private static String userFile;
	
	/**
	 * name of the server where the RMI registry is found
	 */
	private static String rmiHostname;
	
	/**
	 * name that will be used to register the server at the RMI registry
	 */
	private static String rmiObject;
	
	/**
	 * repository root
	 */
	private static String documentRoot;
	
	/**
	 * port where to contact the RMI registry
	 */
	private static int rmiPort;

	public static String getDocumentRoot() {
		return documentRoot;
	}

	public static void setDocumentRoot(String documentRoot) {
		Global.documentRoot = documentRoot;
	}

	public static String getRmiHostname() {
		return rmiHostname;
	}

	public static void setRmiHostname(String rmiHostname) {
		Global.rmiHostname = rmiHostname;
	}

	public static String getRmiObject() {
		return rmiObject;
	}

	public static void setRmiObject(String rmiObject) {
		Global.rmiObject = rmiObject;
	}

	public static int getRmiPort() {
		return rmiPort;
	}

	public static void setRmiPort(int rmiPort) {
		Global.rmiPort = rmiPort;
	}

	public static String getUserFile() {
		return userFile;
	}

	public static void setUserFile(String userFile) {
		Global.userFile = userFile;
	}
	
	private Global() {
		/* do nothing */
	}
}
