package dslab.reservation;

import dslab.reservation.gen.BaseSeminar;
import dslab.reservation.gen.Customer;
import dslab.reservation.gen.ReservationFailed;

public class CancelBookingCommand implements Command {
	public void processCommand(
			dslab.reservation.gen.SeminarReservationSystem server, String[] args)
			throws ReservationFailed {
		for (BaseSeminar seminar : server.listSeminars()) {
			if (seminar.seminarID().equals(args[0])) {
				Customer customer = new CustomerImpl(args[1], args[2]);
				int places = Integer.parseInt(args[3]);

				server.cancelBooking(seminar, customer, places);
				return;
			}
		}

		throw new ReservationFailed("Seminar doesn't exist.");
	}
}
