/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dslab.rmi.common.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import sun.misc.BASE64Encoder;

public class DSLabUtils {
    private DSLabUtils() {
    }

    public static String hashTextWithSHA(String plaintext) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        try {
            md.update(plaintext.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] raw = md.digest();
        String hash = new BASE64Encoder().encode(raw);
        return hash;
    }

    public static boolean isValidEmailAddress(String emailAddr) {
        return emailAddr != null && emailAddr.matches(".+@.+\\.[a-z]+");
    }

    public static Properties loadPropertiesFromClasspath(String propertyFilename) throws IOException {
        Properties p = new Properties();
        InputStream in = ClassLoader.getSystemResourceAsStream(propertyFilename);
        if (in == null) {
            return null;
        }
        p.load(in);
        return p;
    }

    public static Properties loadPropertiesFromFile(String filename) throws IOException {
        Properties p = new Properties();
        if (filename == null || !new File(filename).isFile()) {
            return null;
        }
        p.load(new FileInputStream(filename));
        return p;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = DSLabUtils.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static boolean deleteDir(String dir) {
        File fdir = new File(dir);
        if (fdir.isDirectory()) {
            String[] children = fdir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = DSLabUtils.deleteDir(new File(fdir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return fdir.delete();
    }

    public static boolean deleteDirContent(String dir) {
        File fdir = new File(dir);
        if (fdir.isDirectory()) {
            String[] children = fdir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = DSLabUtils.deleteDir(new File(fdir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static void storeInFile(byte[] content, File file) throws IOException {
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            out.write(content);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

