/*
 * Distributed Systems
 * Winter Term 2006/07
 * Lab 3
 * Paul Staroch, 0425426
 */

package at.ac.tuwien.dslab.rmi.client.command;

import at.ac.tuwien.dslab.rmi.client.command.Command;
import at.ac.tuwien.dslab.rmi.common.impl.UserImpl;
import at.ac.tuwien.dslab.rmi.client.FileManClientConfig;
import at.ac.tuwien.dslab.rmi.common.impl.FileManException;
import at.ac.tuwien.dslab.rmi.common.impl.InvalidCommandException;
import at.ac.tuwien.dslab.rmi.common.interfaces.IFileManager;
import at.ac.tuwien.dslab.rmi.common.impl.RepositoryNotExistsException;
import at.ac.tuwien.dslab.rmi.client.FileManConfigException;

import java.io.File;

import java.rmi.RemoteException;

/**
 * DeleteRepositoryCommand represents the command "del-repo"
 */
public class DeleteRepositoryCommand extends Command {
	/**
	 * Constructor - sets minimal and maximal argument number
	 */
	public DeleteRepositoryCommand() {
		super();
		minArgumentNumber=1;
		maxArgumentNumber=1;
	}

	/**
	 * performs the command
	 *
	 * @param args arguments to the command
	 * @return message for the user (about success or failure)
	 * @throws InvalidCommandException if the command fails due to wrong
	 * 	arguments
	 * @throws FileManException if another error occurs
	 */
	public String executeNoCheckNumber(String... args)
			throws FileManException {
		File workingDir=new File(args[0]);
		if(!workingDir.exists()) {
			throw new RepositoryNotExistsException(args[0]);
		}
		else if (!workingDir.isDirectory()) {
			throw new InvalidCommandException("Specified working "+
					"directory is not a directory.");
		}

		/* read configuration */
		FileManClientConfig config;
		try {
			config=new FileManClientConfig(args[0]);
		}
		catch (FileManConfigException fmce) {
			throw new RepositoryNotExistsException(args[0]);
		}

		IFileManager fileMan;
		try {
			fileMan=getFileManager(config.getHost());
		}
		catch(FileManException fme) {
			return fme.getMessage();
		}

		UserImpl user=new UserImpl();
		user.setName(config.getUsername());
		user.setPasswordHashed(config.getPassword());

		String retval="";
		
		/* delete local files */
		for (String filename : config.getFiles()) {
			File toBeDeleted=new File(args[0]+
					File.separator+filename);
			if(!toBeDeleted.delete()) {
				retval+="Could not delete file: "+
					filename+"\n";
			}		
		}

		if(!config.deleteConfig()) {
			retval+="Could not delete config file.\n";
		}
		if(!workingDir.delete()) {
			retval+="Could not remove working directory.\n";
		}

		/* remove repository from server */
		try {
			fileMan.removeRepository(config.getRepository(),user);
		}
		catch (RemoteException re) {
			return "Communication error while removing "+
				"repository from server";
		}

		return retval.equals("") ? "Repository successfully deleted." : retval;
	}
}

