package dslab.reservation;

import java.util.Collection;
import java.util.LinkedHashMap;

import org.omg.CORBA.ORB;

import dslab.reservation.gen.BaseSeminar;
import dslab.reservation.gen.Customer;
import dslab.reservation.gen.ReservationFailed;
import dslab.reservation.gen.SeminarReservationSystem_dslab158POA;

public class SeminarReservationSystem extends
		SeminarReservationSystem_dslab158POA {
	private LinkedHashMap<String, TxSeminarImpl> seminars = new LinkedHashMap<String, TxSeminarImpl>();

	private ORB orb;

	public SeminarReservationSystem(ORB orb) {
		this.orb = orb;
	}

	public void book(BaseSeminar seminar, Customer customer, int numberPlaces)
			throws ReservationFailed {
		seminars.get(seminar.seminarID()).book(customer, numberPlaces);
	}

	public void cancelBooking(BaseSeminar seminar, Customer customer,
			int numberPlaces) throws ReservationFailed {
		seminars.get(seminar.seminarID()).cancelBooking(customer, numberPlaces);
	}

	public BaseSeminar create(String seminarID, String name, String lecturer,
			int places) {
		TxSeminarImpl seminar = new TxSeminarImpl(orb, seminarID, name,
				lecturer, places);
		seminars.put(seminarID, seminar);
		return seminar._this(SeminarReservationSystemServer.orb);
	}

	public BaseSeminar[] listSeminars() {
		Collection<TxSeminarImpl> seminars = this.seminars.values();

		BaseSeminar[] ret = new BaseSeminar[seminars.size()];
		int j = 0;
		for (TxSeminarImpl seminar : seminars) {
			ret[j++] = seminar._this(SeminarReservationSystemServer.orb);
		}

		return ret;
	}

	public void rebook(BaseSeminar fromSeminar, BaseSeminar toSeminar,
			Customer customer, int numberPlaces) throws ReservationFailed {
		if (!fromSeminar.seminarName().equals(toSeminar.seminarName())) {
			throw new ReservationFailed("Seminar names are not equal.");
		}

		seminars.get(toSeminar.seminarID()).book(customer, numberPlaces);
		seminars.get(fromSeminar.seminarID()).cancelBooking(customer,
				numberPlaces);
	}
}
