package dslab.reservation;

import java.util.HashMap;

import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.NotFound;

import dslab.reservation.gen.ReservationFailed;
import dslab.reservation.gen.SeminarReservationSystemHelper;

public class Client {
	private HashMap<String, Command> commands = new HashMap<String, Command>();

	private HashMap<String, TxCommand> txCommands = new HashMap<String, TxCommand>();

	private void init(org.omg.CORBA.ORB orb) {
		commands.put("create", new CreateCommand());
		commands.put("book", new BookCommand());
		commands.put("cancelBooking", new CancelBookingCommand());

		txCommands.put("booklist", new BooklistCommand(orb));
		txCommands.put("cancellist", new CancellistCommand(orb));
	}

	public static void main(String[] args) {
		Client client = new Client();
		client.run(args);
	}

	private void run(String[] args) {
		try {
			if (args.length < 2) {
				throw new InvalidArgumentCountException();
			}

			java.util.Properties props = new java.util.Properties();
			props
					.put(
							"org.omg.PortableInterceptor.ORBInitializerClass.TSClientInit",
							"org.jacorb.transaction.TransactionInitializer");

			org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, props);

			init(orb);

			if (!transactionCommand(args)) {
				standardCommand(args, orb);
			}
		} catch (ReservationFailed e) {
			System.err.println("Reservation failed.");
			System.exit(1);
		} catch (org.omg.CORBA.UserException e) {
			e.printStackTrace();
			System.exit(1);
		} catch (org.omg.CORBA.SystemException e) {
			e.printStackTrace();
			System.exit(1);
		} catch (InvalidArgumentCountException e) {
			System.err.println("Invalid number of arguments.");
			System.exit(1);
		} catch (NumberFormatException e) {
			System.err.println(e.getMessage());
			System.exit(1);
		}
	}

	private void standardCommand(String[] args, org.omg.CORBA.ORB orb)
			throws InvalidName,
			org.omg.CosNaming.NamingContextPackage.InvalidName, NotFound,
			CannotProceed, InvalidArgumentCountException, ReservationFailed {
		dslab.reservation.gen.SeminarReservationSystem server;

		NamingContextExt nc = NamingContextExtHelper.narrow(orb
				.resolve_initial_references("NameService"));

		org.omg.CORBA.Object o = nc
				.resolve(new NameComponent[] { new NameComponent(args[0],
						"server") });

		server = SeminarReservationSystemHelper.narrow(o);

		if (!commands.containsKey(args[1])) {
			System.err.println("Unknown command: " + args[1]);
			System.exit(1);
		}

		String[] commandArgs = new String[args.length - 2];
		System.arraycopy(args, 2, commandArgs, 0, commandArgs.length);

		commands.get(args[1]).processCommand(server, commandArgs);
	}

	private boolean transactionCommand(String[] args)
			throws InvalidArgumentCountException, InvalidName,
			ReservationFailed {
		if (!txCommands.containsKey(args[0])) {
			return false;
		}

		String[] commandArgs = new String[args.length - 1];
		System.arraycopy(args, 1, commandArgs, 0, commandArgs.length);

		txCommands.get(args[0]).processCommand(commandArgs);

		return true;
	}
}
