package dslab.reservation;

import java.util.HashMap;

import dslab.reservation.gen.Customer;
import dslab.reservation.gen.ReservationFailed;
import dslab.reservation.gen.SeminarPOA;

public class SeminarImpl extends SeminarPOA {
	private String lecturer;

	private int places;

	private int openPlaces;

	private String seminarID;

	private String seminarName;

	private HashMap<String, Integer> customerPlaces = new HashMap<String, Integer>();

	public SeminarImpl(String seminarID, String name, String lecturer,
			int places) {
		this.seminarID = seminarID;
		this.seminarName = name;
		this.lecturer = lecturer;
		this.places = places;
		this.openPlaces = places;
	}

	public void book(Customer customer, int numberPlaces)
			throws ReservationFailed {
		if (openPlaces < numberPlaces) {
			throw new ReservationFailed("Not enough open places.");
		}
		openPlaces -= numberPlaces;

		String key = customer.firstName + "::" + customer.lastName;
		customerPlaces.put(key,
				customerPlaces.containsKey(key) ? customerPlaces.get(key)
						+ numberPlaces : numberPlaces);
	}

	public void cancelBooking(Customer customer, int numberPlaces)
			throws ReservationFailed {
		String key = customer.firstName + "::" + customer.lastName;
		if (!customerPlaces.containsKey(key)
				|| customerPlaces.get(key).intValue() < numberPlaces) {
			throw new ReservationFailed("Not enough booked places.");
		}
		openPlaces += numberPlaces;

		customerPlaces.put(key, customerPlaces.get(key) - numberPlaces);
	}

	public int openPlaces() {
		return openPlaces;
	}

	public int places() {
		return places;
	}

	public String lecturer() {
		return lecturer;
	}

	public String seminarID() {
		return seminarID;
	}

	public String seminarName() {
		return seminarName;
	}

	public void seminarName(String seminarName) {
		this.seminarName = seminarName;
	}
}
